<?php
/** Generated Model Class **/ 

Class {{ class }} {    
	private static $columns = "{{ columns }}";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
{% for f in fields %}{% if f.required == 'true' %}
		$rules[] = "required,{{f.name}},{{f.name}} belum terisi.";
{% endif %}{% endfor %}
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		${{ name }} = R::dispense("{{ name }}");
		
{% for f in fields %}{% if f.type == 'date' %}
		$array = self::generate_date('{{f.name}}',$array);
{% endif %}{% endfor %}
		if (!self::validate_fields($array)) return false;
		
		${{ name }}->import($array,self::$columns);		
		$id = R::store(${{ name }});
		
		return $id;
	}
	
	public static function update($id,$array) {
		${{ name }} = R::load("{{ name }}",$id);
		
{% for f in fields %}{% if f.type == 'date' %}
		$array = self::generate_date('{{f.name}}',$array);
{% endif %}{% endfor %}
		if (!self::validate_fields($array)) return false;
		
		${{ name }}->import($array,self::$columns);		
		
		$id = R::store(${{ name }});
		R::store(${{ name }});
		return true;
	}	
	
	public static function countAll() {
		return R::getCell("select count(1) from {{name}}");
	}
	
	public static function getAll($page = 1,$count_per_page = 0) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select * from {{name}} order by id desc limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
{% for f in fields %}{% if f.type == 'date' %}
			$data[$key]['{{f.name}}'] = date("d-m-Y",$data[$key]['{{f.name}}']);
{% endif %}{% endfor %}
		}
		
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll()/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from {{ name }} where id = $id");
		
{% for f in fields %}{% if f.type == 'date' %}
		$data['{{f.name}}'] = date("d-m-Y",$data['{{f.name}}']);
{% endif %}{% endfor %}
		
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("{{ name }}",$id);
		
		R::trash($data);
	}
	
}
?>
