<?php


/**
 * {{ name }} login
 */
Slim::get('/{{ name }}/',function() {
	Slim::render("{{ name }}/login.html");
})->name('{{ name }}_login');

Slim::post('/{{ name }}/',function() {
	if ({{ class }}::login($_POST['{{ fields.0.name }}'],$_POST['{{ fields.1.name }}'])) {
		redir_by_id('{{ name }}');
	} else {
		Slim::flash("error","login failed");
		redir_by_id('{{ name }}_login');
	}
});

/**
 * {{ name }} logout
 */
Slim::get('/{{ name }}/logout',function() {
	{{ class }}::logout();
	redir_by_id('{{ name }}_login');
})->name('{{ name }}_logout');

/**
 * {{ name }} home
 */
Slim::get('/{{ name }}/home',function() {
	if ({{ class }}::is_login()) {
		Slim::render("{{ name }}/home.html");
	} else {
		redir_by_id('{{ name }}_login');
	}
})->name('{{ name }}');


/**
 * Show All {{ name }} / Show Detail (if {{ name }} id is present)
 */
Slim::get('/{{ name }}/list(/:id)',function($id = 0) {
	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		$data = {{ class }}::getAll($current_page,$count_per_page);
		$page = {{ class }}::generatePage($current_page,$count_per_page,Slim::urlfor("{{name}}"));
		
		Slim::render('{{ name }}/list.html',array(
			'page' => $page,
			'data' => $data
		));
	} else {
		$data = {{ class }}::get($id);
		Slim::render('{{ name }}/view.html',array(
			"data" => $data
		));
	}
})->name('{{ name }}_list');

/**
 * New {{ name }}
 */
Slim::get('/{{ name }}/new/',function() {
	$columns = {{ class }}::getColumns();
	Slim::render("{{ name }}/new.html",array("columns"=>$columns));
})->name('{{ name }}_new');

Slim::post('/{{ name }}/new/',function() {
	if ({{ class }}::create($_POST)) {
		redir_by_id("{{ name }}_login");
	} else {
		Slim::render('{{ name }}/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit {{ name }}
 */
Slim::get('/{{ name }}/edit(/:id)',function($id = 0) {
	if ($id == 0) redir_by_id("{{ name }}");
	$data = {{ class }}::get($id);
	Slim::render('{{ name }}/edit.html',array(
		"data" => $data
	));
})->name('{{ name }}_edit'); 

Slim::post('/{{ name }}/edit(/:id)',function($id = 0) {
	if ($id == 0) redir_by_id('{{ name }}_list');
	
	if ({{ class }}::update($id,$_POST)) {
		redir_by_id('{{ name }}_list');
	} else {
		Slim::render('{{ name }}/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete {{ name }}
 */
Slim::get('/{{ name }}/del(/:id)',function($id = 0) {
	if ($id == 0) redir_by_id('{{ name }}_list');
	
	{{ class }}::remove($id);
	redir_by_id('{{ name }}_list');
})->name('{{ name }}_del');

?>
