<?php
/** Generated Model Class **/ 

Class Obat {    
	private static $columns = "kode,nama,id_kategori,id_generic,id_satuan_kecil,id_satuan_besar,konversi,keterangan,kandungan,khasiat,status,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$obat = R::dispense("m_obat");
		if (!self::validate_fields($array)) return false;
		
		$obat->import($array,self::$columns);		
		$id = R::store($obat);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$obat = R::load("m_obat",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$obat->import($array,self::$columns);		
		
		R::store($obat);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from m_obat");
	}
	
	public static function countAllKriteria($kriteria = "") {
		return R::getCell("select count(1) from m_obat where nama like '%".$kriteria."%' or harga_jual like '%".$kriteria."%' or kode like '%".$kriteria."%'");
	}
		
	public static function getAll() {
		$q = "select * from m_obat order by nama asc";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getFull($id = 0) {
		if ($id > 0) {
			$where = "WHERE o.id = $id";
		} else {
			$where = "";
		}
		$q = "SELECT o.*, sk.kode as kecil, sb.kode as besar, ko.nama as kategori, g.nama as generic FROM m_obat o 
				LEFT JOIN m_satuan sk ON o.id_satuan_kecil = sk.id
				LEFT JOIN m_satuan sb ON o.id_satuan_besar = sb.id
				LEFT JOIN m_kategori_obat ko ON o.id_kategori = ko.id
				LEFT JOIN m_generic_obat g ON o.id_generic = g.id $where";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByKriteria($page = 1,$count_per_page = 0,$kriteria = "") {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select o.*, ok.cnt from (select * from m_obat where nama like '%".$kriteria."%' or kode like '%".$kriteria."%' or harga_jual like '%".$kriteria."%' order by nama asc limit $start_record,$count_per_page) o 
				left join (select id_obat, count(*) as cnt from obat_keluar_detail group by id_obat) ok on o.id = ok.id_obat";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePageKriteria($current_page,$count_per_page,$base_url,$kriteria = "") {
		$total_page = ceil(self::countAllKriteria($kriteria)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			if ($kriteria == "") {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
			} else {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?find=".$kriteria."&p=$i");
			}
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from m_obat where id = $id");
		return $data;
	}
	
	public static function getByGol($id) {
		if ($id == 1) {
			$data = R::getAll("select * from m_obat where status = 's' and aktif = 'y'");
		} else {
			$data = R::getAll("select * from m_obat where status != 's' and aktif = 'y'");
		}
		return $data;
	}
	
	public static function getNama($id) {
		$data = R::getCell("select nama from m_obat where id = $id");
		return $data;
	}
	
	public static function cekUsed($id) {
		$masuk = R::getCell("SELECT count(*) FROM obat_masuk WHERE id_obat = $id");
		$keluar = R::getCell("SELECT count(*) FROM obat_keluar WHERE id_obat = $id");
		return $masuk + $keluar;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		// $data = self::get($id);
		// $data['aktif'] = "t";
		// self::update($data);
		$data = R::load("m_obat",$id);
		R::trash($data);
	}

	public static function delete($id) {
		$data = R::load("m_obat",$id);
		R::trash($data);
	}
}
?>
