<?php
/** Generated Model Class **/ 

Class Kunjungan {    
	private static $columns = "no_kunjungan,id_pasien,id_golongan,tgl,keluhan,diagnosis,keterangan,rujuk_ke,id_dokter,id_poli,id_resepsionis,id_perawat,id_ttv,baru,status";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,id_pasien,id_pasien belum terisi.";
		$rules[] = "required,tgl,tanggal belum terisi.";
		$rules[] = "required,id_poli,poli belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$kunjungan = R::dispense("kunjungan");
		
		if (!self::validate_fields($array)) return false;
		
		$kunjungan->import($array,self::$columns);
		
		$id = R::store($kunjungan);
		
		return $id;
	}

	public static function update($id,$array) {
		$kunjungan = R::load("kunjungan",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$kunjungan->import($array,self::$columns);		
		
		R::store($kunjungan);
		return true;
	}
	
	public static function updateStatus($id,$array) {
		$kunjungan = R::load("kunjungan",$id);
		
		$kunjungan->import($array,self::$columns);		
		
		R::store($kunjungan);
		return true;
	}
	
	public static function countAll() {
		return R::getCell("select count(1) from kunjungan");
	}
	
	public static function getAll($page = 1,$count_per_page = 0) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		
		$q = "select a.*, n.nama as pasien from (select k.*, p.nama as poli from kunjungan k inner join m_poli p on k.id_poli = p.id) a inner join m_pasien n on a.id_pasien = n.id order by a.id desc limit $start_record,$count_per_page";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getFull($id) {
		$data = self::get($id);
		$data['poli'] = Poli::getNama($data['id_poli']);
		$data['golongan'] = Golongan::getNama($data['id_golongan']);
		$data['pasien'] = Pasien::get($data['id_pasien']);	//array
		$data['dokter'] = User::getNama($data['id_dokter']);

		return $data;
	}
	
	public static function getByDate($date) {
		// $q = "select a.*, n.nama as pasien from (select k.*, p.nama as poli from kunjungan k inner join m_poli p on k.id_poli = p.id) a inner join m_pasien n on a.id_pasien = n.id where date_format(tgl,'%d-%m-%Y') = '".$date."'";
		$q = "select a.*, n.nama, n.alamat, n.no_rekmed, n.tgl_lahir, n.sex from (select kg.*, p.nama as poli from (select k.*, g.nama as golongan from kunjungan k inner join m_golongan g on k.id_golongan = g.id where FROM_UNIXTIME(tgl,'%d-%m-%Y') = '".$date."' ) kg inner join m_poli p on kg.id_poli = p.id) a inner join m_pasien n on a.id_pasien = n.id order by a.id";
		
		R::exec("set time_zone = '+07:00'");
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByDatePoli($date,$id_poli) {
		$q = "select a.*, n.nama, n.alamat, n.no_rekmed, n.tgl_lahir, n.sex from (select kg.*, p.nama as poli from (select k.*, g.nama as golongan from kunjungan k inner join m_golongan g on k.id_golongan = g.id where FROM_UNIXTIME(tgl,'%d-%m-%Y') = '".$date."' and id_poli = $id_poli ) kg inner join m_poli p on kg.id_poli = p.id) a inner join m_pasien n on a.id_pasien = n.id order by a.id";
		
		R::exec("set time_zone = '+07:00'");
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getListHistori($id_pasien) {
		$q = "select id, FROM_UNIXTIME(tgl,'%d %M %Y') as tglh from kunjungan where id_pasien = $id_pasien";

		R::exec("set time_zone = '+07:00'");
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getHistoriAjax($date) {
		//return R::getAll("select * from kunjungan where FROM_UNIXTIME(date,'%d-%m-%Y') like '".$date."' order by id desc");
	}
	
	public static function getByNomor($nomor) {
		$q = "select k.*, p.nama as poli from kunjungan k inner join m_poli p on p.id = k.id_poli where k.no_rekmed = '".$nomor."' order by k.tgl desc ";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByPasien($idp) {
		$q = "select k.*, p.nama from kunjungan k inner join m_pasien p on p.id = k.id_pasien where p.id = '$idp' order by k.tgl asc ";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByStatus($status) {
		$q = "select * from kunjungan where status = '$status'";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getAkhir() {
		$q = "select from_unixtime(a.tgl,'%d/%m/%Y') as tanggal, n.nama as pasien, a.poli, a.diagnosis, a.id, n.tgl_lahir, n.sex, n.no_rekmed from 
			 (select k.*, p.nama as poli from kunjungan k inner join m_poli p on k.id_poli = p.id order by k.tgl desc) a inner join m_pasien n on a.id_pasien = n.id group by pasien, poli order by tanggal";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getRm() {
		$q = "select no_rekmed from m_pasien group by no_rekmed order by no_rekmed";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll()/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		R::exec("set time_zone = '+07:00'");
		$data = R::getRow("select *, from_unixtime(tgl,'%d/%m/%Y') as tanggal, from_unixtime(tgl,'%H:%i') as jam from kunjungan where id = $id");
		return $data;
	}
	
	public static function getAntrian($poli) {
		R::exec("set time_zone = '+07:00'");
		$data = R::getRow("select no_kunjungan from kunjungan where id_poli = ".$poli." and from_unixtime(tgl,'%d-%m-%Y') = '".date('d-m-Y')."' order by id desc");
		$no = $data['no_kunjungan'];
		$poli = poli::get($poli);
		if ($no == null) {
			$no = 1;
		} else {
			$no = substr($no,1)*1;
			$no += 1;
		}
		$no = $poli['kode'].$no;
		return $no;
	}
	
	public static function getGolongan($id) {
		$data = R::getCell("select id_golongan from kunjungan where id = $id");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function delete($id) {
		$data = R::load("kunjungan",$id);
		R::trash($data);
		Transaksi::deleteByKunjungan($id);
	}
}
?>
