<?php
/** Generated Model Class **/ 

Class Biaya {    
	private static $columns = "nama,id_golongan,harga,id_akun,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$biaya = R::dispense("m_biaya");
		if (!self::validate_fields($array)) return false;
		
		$biaya->import($array,self::$columns);		
		$id = R::store($biaya);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$biaya = R::load("m_biaya",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$biaya->import($array,self::$columns);		
		
		R::store($biaya);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from m_biaya");
	}
		
	public static function getAll() {
		$q = "select * from m_biaya";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getAllAktif() {
		$q = "select * from m_biaya where aktif = 'y'";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from m_biaya where id = $id");
		return $data;
	}
	
	public static function getHarga($id) {
		$data = R::getCell("select harga from m_biaya where id = $id");
		return $data;
	}
	
	public static function getByGol($gol) {
		switch ($gol) {
			case "dhuafa":
				$g = "1";
				break;
			case "khusus":
				$g = "2";
				break;
			case "umum":
				$g = "3";
				break;
			case "mou":
				$g = "4";
				break;
		}
		$data = R::getAll("select id, nama from m_biaya where id_golongan = $g and aktif = 'y'");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("m_biaya",$id);
		R::trash($data);
	}
}
?>
