<?php
/** Generated Model Class **/ 

Class Absensi {    
	private static $columns = "id_kurir,shift,tgl,jam_datang,jam_keluar,hantaran,kehadiran,backup";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,id_kurir,id_kurir belum terisi.";
		$rules[] = "required,tgl,tgl belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$absensi = R::dispense("absensi");
		
		if (!self::validate_fields($array)) return false;
		
		$absensi->import($array,self::$columns);		
		$id = R::store($absensi);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$absensi = R::load("absensi",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$absensi->import($array,self::$columns);		
		
		$id = R::store($absensi);
		return true;
	}	
	
	public static function countAll() {
		return R::getCell("select count(1) from absensi");
	}
	
	public static function getAll($page = 1,$count_per_page = 0) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select * from absensi order by id desc limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
		}
		
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll()/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from absensi where id = $id");
		
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		R::exec("delete from absensi where id_kurir = $id");
	}
	
	public static function hadir($id,$shift) {
		$q = "select * from absensi where id_kurir = $id and shift like '{$shift}' and tgl like '".date('d-m-Y')."'";
		$data = R::getRow($q);
		Kurir::changeStatus($id,"available");
		Store::changeStatus($_SESSION['user']['store']['id'],"av");
	
		if (empty($data)) {
			$id = self::create(array(
				"id_kurir"=>$id,
				"shift"=>$shift,
				"tgl"=>date('d-m-Y'),
				"kehadiran"=>"hadir",
				"jam_datang"=>date('H:i'),
				"hantaran"=>0
			));
			return self::get($id);
		}
		else {
			return $data;
		}
	}
	
	public static function backup($id,$backup,$shift) {
		$q = "select * from absensi where id_kurir = $id and shift like '{$shift}' and tgl like '".date('d-m-Y')."'";
		$data = R::getRow($q);
		Kurir::changeStatus($id,"available");
			
		if (empty($data)) {
			$id = self::create(array(
				"id_kurir"=>$id,
				"tgl"=>date('d-m-Y'),
				"kehadiran"=>"backup",
				"shift"=>$shift,
				"backup"=>$backup,
				"jam_datang"=>date('H:i'),
				"hantaran"=>0
			));
			
			return self::get($id);
		}
		else {
			return $data;
		}
		
	}
	
	public static function keluar($id,$shift) {
		$q = "select * from absensi where id_kurir = $id and shift like '{$shift}' and tgl like '".date('d-m-Y')."'";
		$data = R::getRow($q);
		
		$absensi = R::load("absensi",$data['id']);
		$absensi->jam_keluar = date('H:i');
	
		Kurir::changeStatus($id,"pulang");
		$kurirAvail = Kurir::countAvailableByStore($_SESSION['user']['store']['id']);
		if ($kurirAvail == 0) {
			Store::changeStatus($_SESSION['user']['store']['id'],"na");
		}
		
		$id = R::store($absensi);
		
		return self::get($id);
	}
	public static function hantaranplus($id) {
		$q = "select * from absensi where id_kurir = $id and tgl like '".date('d-m-Y')."' and jam_keluar is null";
		$data = R::getRow($q);
		
		$absensi = R::load("absensi",$data['id']);
		$absensi->hantaran += 1;
		$id = R::store($absensi);
		return self::get($id);
	}
	public static function hantaranminus($id) {
		$q = "select * from absensi where id_kurir = $id and tgl like '".date('d-m-Y')."' and jam_keluar is null";
		$data = R::getRow($q);
		
		$absensi = R::load("absensi",$data['id']);
		$absensi->hantaran = ($absensi->hantaran -1 <= 0 ? 0 : $absensi->hantaran -1);
		$id = R::store($absensi);
		return self::get($id);
	}
	
	public static function getByStoreDate($id,$date) {
		$q = "select *,a.id as id from kurir a left outer join (select * from absensi where tgl like '".date('d-m-Y',$date)."') b on a.id = b.id_kurir where id_store = $id and CONCAT(RIGHT(a.mulai,4), '-', MID(a.mulai,4,2), '-', LEFT(a.mulai,2)) <= '".date('Y-m-d',$date)."' and ((CONCAT(RIGHT(a.berhenti,4), '-', MID(a.berhenti,4,2), '-', LEFT(a.berhenti,2)) >= '".date('Y-m-d',$date)."' and ('".date('Y-m-d',$date)."' < curdate() or b.tgl != 'NULL')) or a.berhenti = '') order by a.nama";
		$data = R::getAll($q);

		$lastname ="";
		foreach ($data as $k=>$d) {
			if ($lastname == $d['nama'] && $d['backup'] == "") {
				$data[$k]['nama'] = "";
			}
			$lastname = $d['nama'];
			
			if ($d['tgl'] == null) { 
				$data[$k]['status'] = 'off';
				//Kurir::update($data[$k]['id'],$data[$k]);
			}
			if ($d['shift_2'] != "") {
				$s2[] = array("id"=>$d['id'],"s"=>$d['shift_2']);
			}
			if ($d['shift'] == null) $data[$k]['shift'] = $d['shift_1'];
		}
		
		if (!isset($s2)) { return $data; }
		
		foreach ($s2 as $s) {
			$insert = false;
			foreach ($data as $k=>$d) {
				if ($s['id'] == $d['id'] && $d['shift'] == $s['s']) {
					$insert = true;
				}
			}
			if (!$insert) {
				$idx = 0;
				foreach ($data as $k=>$d) {
					if ($s['id'] == $d['id']) $idx = $k + 1;
				}
				$new = $data[$idx -1];
				$new['shift'] = $s['s'];
				$new['nama'] = ($new['backup'] == "" ? "" : $new['nama']);
				$new['tgl'] = null;
				$new['kehadiran'] = null;
				$new['jam_datang'] = null;
				$new['jam_keluar'] = null;
				$new['hantaran'] = null;
				array_splice($data,$idx,0,array($new));
			}
		}
		
		return $data;
	}
	
	
}
?>
