<?php
/**
 * Tempe - Tasty PHP Application Framework
 *
 * @author      Dropsugar
 * @link        http://www.dropsugar.com
 * @copyright   2011 Rizky Ramadhan
 *
 * What? License?
 *
 **/
ini_set("display_errors","On");
session_start();
date_default_timezone_set('Asia/Jakarta');

//require tempe
require 'tempe/redbean/rb.php'; 			// RedBeanPHP 1.3.2 	(http://www.redbeanphp.com)
require 'tempe/h2o/h2o/h2o.php'; 			// h2o 1.4.1			(http://www.h2o-template.org)
require 'tempe/Slim/Slim.php'; 				// Slim 1.3.2			(http://www.slimframework.com)
require 'tempe/h2o/h2oView.php';			// h2o - Slim binding	(Rizky Ramadhan)
require 'tempe/mailer/ActionMailer.php'; 	// ActionMailer 0.1		(Rizky Ramadhan)
require 'tempe/class.upload.php'; 			// class.upload 0.31	(http://www.verot.net)
require 'tempe/curl.php'; 					// Php Curl 			(http://php.net/manual/en/book.curl.php)
require 'tempe/phpQuery-onefile.php'; 			// PhpQuery				(http://code.google.com/p/phpquery)

//initialize slim
$mode = 'production'; //when it's ready, change this to 'production'
Slim::init(array(
    'mode' => $mode, 
    'view' => 'h2oView',
    'templates.path' => './views'
));

//require all models
foreach (glob("models/*.php") as $filename) { require $filename; }

//require all controllers
foreach (glob("controllers/*.php") as $filename) { require $filename; }


//define mode configuration
Slim::configureMode('production', function () {
	$db_user = "Slim-15363";
	$db_password = "mosokseh";
	$db_name = "awcc-phpfogapp-com";
	R::setup("mysql:host=db01-share;dbname=$db_name",$db_user,$db_password);
	
    Slim::config(array(
        'log.enable' => true,
        'log.path' => 'tempe/logs',
        'debug' => true
    ));
});

Slim::configureMode('development', function () {
	$db_user = "root";
	$db_password = "okedeh";
	$db_name = "karya";

	R::setup("mysql:host=localhost;dbname=$db_name",$db_user,$db_password);

    Slim::config(array(
        'log.enable' => false,
        'debug' => true
    ));

});

//require validator
require 'tempe/validation/validation.php';		// PHP Validation v2.3.3 (http://www.benjaminkeen.com/software/php_validation)
require 'tempe/validation/validator.php';		// RedBeanPHP Validator (Rizky Ramadhan 2011)

//okay, all set... Go!
Slim::run();

?>

