<?php 

/**
 * Super Admin Authentication
 */
 
Slim::get('/admin/(:model)(/:action)(/:id)',function($model= 0,$action = 0,$id = 0) {
	User::check_login('admin');
	Slim::pass();
});

/**
 * Get list Pasien
 */
 
Slim::get('/admin/rekmed(/:id)',function($id = "") {
	User::check_login('admin');

	if ($id == "") {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		$kriteria = array();
		
		if (isset($_GET["no_rekmed"])) $kriteria[0] = $_GET["no_rekmed"];
		else $kriteria[0] = "";
		
		if (isset($_GET["nama"])) $kriteria[1] = $_GET["nama"];
		else $kriteria[1] = "";
		
		if (isset($_GET["no_kk"])) $kriteria[2] = $_GET["no_kk"];
		else $kriteria[2] = "";
		
		$data = Pasien::getByKriteria($current_page,$count_per_page,$kriteria);
		$page = Pasien::generatePageKriteria($current_page,$count_per_page,Slim::urlfor("admin_rekmed"),$kriteria);
		foreach ($data as $d=>$t) {
			$data[$d]["tgl_lahir"] = Rumus::reverseDate($t["tgl_lahir"]);
		}
		
		Slim::render('admin/rekmed/list.html',array(
			'page' => $page,
			'data' => $data,
			'kriteria' => $kriteria
		));
	} else {
		$data = Pasien::getByRekMed($id);
		$rekmed = Kunjungan::getByNomor($data['no_rekmed']);
		$data["tgl_lahir"] = Rumus::reverseDate($data["tgl_lahir"]);
		
		Slim::render('admin/rekmed/view.html',array(
			"data" => $data,
			"rekmed" => $rekmed
		));
	}
})->name('admin_rekmed');

/**
 * New rekmed
 */
 
Slim::get('/admin/rekmed/baru(/:id)',function($id = "") {
	User::check_login('admin');
	// User::check_permit('edit','rekmed');

	$columns = Kunjungan::getColumns();
	Slim::render("admin/rekmed/new.html",array(
		"columns"=>$columns,
		"id"=>$id
	));
})->name('admin_rekmed_new');

Slim::post('/admin/rekmed/baru(/:id)',function($id = "") {
	User::check_login('admin');
	// User::check_permit('edit','rekmed');

	$_POST["tgl"] = Rumus::reverseDate($_POST["tgl"]);
	$idPasien = Kunjungan::getIdPasien($id);
	
	if (Kunjungan::create($_POST)) {
		redir_by_id("admin_rekmed");
	} else {
		Slim::render('admin/rekmed/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit rekmed
 */
 
Slim::get('/admin/rekmed/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_rekmed");
	$data = Kunjungan::get($id);
	$data["tgl"] = Rumus::reverseDate($data["tgl"]);
	
	Slim::render('admin/rekmed/edit.html',array(
		"data" => $data
	));
})->name('admin_rekmed_edit');

Slim::post('/admin/rekmed/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_rekmed");
	$_POST["tgl"] = Rumus::reverseDate($_POST["tgl"]);
	$idPasien = Kunjungan::getIdPasien($id);
	
	if (Kunjungan::update($id,$_POST)) {
		redir_by_id("admin_rekmed");
	} else {
		Slim::render('admin/rekmed/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete rekmed
 */
 
Slim::get('/admin/rekmed/del(/:id)',function($id = 0) {
	User::check_login('admin');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_rekmed");
	$idPasien = Kunjungan::getIdPasien($id);
	Rekmed::remove($id);
	redir_by_id("admin_rekmed",array(),"/".$idPasien);
})->name('admin_rekmed_del');

/**
 * Get Pasien - Ajax Long Pooling
 */

Slim::get('/admin/get_pasien',function() {
	// User::check_login('admin',function () {
		// echo json_encode(array("unauthorized"=>"true"));
	// });
	$data = Pasien::getByKriteria();
	echo json_encode($data);
})->name('admin_get_pasien');

?>