<?php

/**
 * Show All poli / Show Detail (if poli id is present)
 */
Slim::get('/admin/poli(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','poli');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		if (isset($_GET["find"])) $find = $_GET["find"];
		else $find = "";
	
		$data = Poli::getAll($current_page,$count_per_page,$find);
		$page = Poli::generatePage($current_page,$count_per_page,Slim::urlfor("admin_poli"),$find);
		
		Slim::render('admin/poli/list.html',array(
			'page' => $page,
			'data' => $data
		));
	} else {
		$data = Poli::get($id);
		Slim::render('admin/poli/view.html',array(
			"data" => $data
		));
	}
})->name('admin_poli');

/**
 * New poli
 */
Slim::get('/admin/poli/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','poli');

	$columns = Poli::getColumns();
	$menu_cols = Menu::getColumns();
	foreach ($menu_cols as $m) {
		if ($m != "caption" &&
			$m != "nama" &&
			$m != "jenis" &&
			$m != "kode") {
			$kategori_menu[] = strtoupper($m);
		}
	}
	$kategori_menu[] = "#N/A";
	Slim::render("admin/poli/new.html",array(
		"columns"=>$columns,
		"kategori_menu" => $kategori_menu
	));
})->name('admin_poli_new');

Slim::post('/admin/poli/new/',function() {
	User::check_login('admin');
	//ser::check_permit('edit','poli');

	if (Poli::create($_POST)) {
		redir_by_id("admin_poli");
	} else {
		Slim::render('admin/poli/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit poli
 */
Slim::get('/admin/poli/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','poli');

	if ($id == 0) redir_by_id("admin_poli");
	$data = Poli::get($id);
	$menu_cols = Menu::getColumns();
	foreach ($menu_cols as $m) {
		if ($m != "caption" &&
			$m != "nama" &&
			$m != "jenis" &&
			$m != "kode") {
			$kategori_menu[] = strtoupper($m);
		}
	}
	$kategori_menu[] = "#N/A";
	$shift = PoliShift::getByPoli($id);
	
	Slim::render('admin/poli/edit.html',array(
		"data" => $data,
		"kategori_menu" => $kategori_menu,
		"shift"=>$shift
	));
})->name('admin_poli_edit'); 

Slim::post('/admin/poli/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','poli');

	if ($id == 0) redir_by_id('admin_poli');
	
	if (Poli::update($id,$_POST)) {
		redir_by_id('admin_poli');
	} else {
		Slim::render('admin/poli/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete poli
 */
Slim::get('/admin/poli/del(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','poli');

	if ($id == 0) redir_by_id('admin_poli');

	Poli::remove($id);
	redir_by_id('admin_poli');
})->name('admin_poli_del');

?>
