<?php

/**
 * Show All periksa / Show Detail (if periksa id is present)
 */
Slim::get('/admin/periksa(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) {
		if (isset($_GET['tgl'])) {
			$d = explode('-',$_GET['tgl']);
			$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		} else { $time = time(); }
		
		$data = Kunjungan::getByDate($time);
		
		Slim::render('admin/periksa/list.html',array(
			'data' => $data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time),
			'current' => getdate()
		));
	} else {
		$data = Kunjungan::get($id);
		$customer = Customer::get($data['id_customer']);
		$store = Store::get($data['id_store']);
		$menu = MenuOrder::get($data['id']);
		$totalprice = MenuOrder::countTotalPrice($menu) + 12500;
		$kurir = Kurir::joinNamaKurir(Kurir::getByOrder($data['id']));
		
		$data['date_detail'] = getdate($data['date']);
		
		Slim::render('admin/periksa/view.html',array(
			"order" => $data,
			"customer"=>$customer,
			"store"=>$store,
			"menu"=>$menu,
			"kurir"=>$kurir,
			"totalprice"=>$totalprice
		));
	}
})->name('admin_periksa');

/**
 * New periksa
 */
Slim::get('/admin/periksa/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	$columns = Kunjungan::getColumns();
	Slim::render("admin/periksa/new.html",array("columns"=>$columns));
})->name('admin_periksa_new');

Slim::post('/admin/periksa/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if (Kunjungan::create($_POST)) {
		redir_by_id("periksa");
	} else {
		Slim::render('admin/periksa/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit periksa
 */
Slim::get('/admin/periksa/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("periksa");
	$data = Kunjungan::get($id);
	Slim::render('admin/periksa/edit.html',array(
		"data" => $data
	));
})->name('admin_periksa_edit'); 

Slim::post('/admin/periksa/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('periksa');
	
	if (Kunjungan::update($id,$_POST)) {
		redir_by_id('periksa');
	} else {
		Slim::render('admin/periksa/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete periksa
 */
Slim::get('/admin/periksa/del(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('periksa');

	Kunjungan::remove($id);
	redir_by_id('periksa');
})->name('admin_periksa_del');

?>