<?php

/**
 * Super Admin Home
 */
 
// Slim::get('/admin/home',function() {
	// User::check_login('management');
	
	// redir_by_id("admin_pasien");
// })->name('admin_home');

/**
 * Show All pasien / Show Detail (if pasien id is present)
 */
 
Slim::get('/admin/pasien(/:id)',function($id = 0) {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		if (isset($_GET["find"])) {
			$data = Pasien::getByKriteria($current_page,$count_per_page,$_GET["find"]);
		} else {
			$data = Pasien::getAll($current_page,$count_per_page);
		}
		$page = Pasien::generatePage($current_page,$count_per_page,Slim::urlfor("admin_pasien"));
		foreach ($data as $d=>$t) {
			$data[$d]["tgl_lahir"] = Rumus::reverseDate($t["tgl_lahir"]);
		}
		
		Slim::render('admin/pasien/list.html',array(
			'page' => $page,
			'data' => $data
		));
	} else {
		$data = Pasien::get($id);
		Slim::render('admin/pasien/view.html',array(
			"data" => $data
		));
	}
})->name('admin_pasien');

/**
 * New pasien
 */
 
Slim::get('/admin/pasien/baru/',function() {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	$columns = Pasien::getColumns();
	Slim::render("admin/pasien/new.html",array("columns"=>$columns));
})->name('admin_pasien_new');

Slim::post('/admin/pasien/baru/',function() {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	$_POST["tgl_lahir"] = Rumus::reverseDate($_POST["tgl_lahir"]);
	
	if (Pasien::create($_POST)) {
		redir_by_id("admin_pasien");
	} else {
		Slim::render('admin/pasien/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit pasien
 */
 
Slim::get('/admin/pasien/edit(/:id)',function($id = 0) {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_pasien");
	$data = Pasien::get($id);
	$data["tgl_lahir"] = Rumus::reverseDate($data["tgl_lahir"]);
	
	Slim::render('admin/pasien/edit.html',array(
		"data" => $data
	));
})->name('admin_pasien_edit');

Slim::post('/admin/pasien/edit(/:id)',function($id = 0) {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_pasien");
	$_POST["tgl_lahir"] = Rumus::reverseDate($_POST["tgl_lahir"]);
	
	if (Pasien::update($id,$_POST)) {
		redir_by_id("admin_pasien");
	} else {
		Slim::render('admin/pasien/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete pasien
 */
 
Slim::get('/admin/pasien/del(/:id)',function($id = 0) {
	User::check_login('management');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("admin_pasien");

	Pasien::remove($id);
	redir_by_id("admin_pasien");
})->name('admin_pasien_del');

?>
