<?php

/**
 * Show All obat / Show Detail (if obat id is present)
 */
Slim::get('/admin/obat(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) {
		if (isset($_GET['tgl'])) {
			$d = explode('-',$_GET['tgl']);
			$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		} else { $time = time(); }
		
		$data = Kunjungan::getByDate($time);
		
		Slim::render('admin/obat/list.html',array(
			'data' => $data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time),
			'current' => getdate()
		));
	} else {
		$data = Kunjungan::get($id);
		$customer = Customer::get($data['id_customer']);
		$store = Store::get($data['id_store']);
		$menu = MenuOrder::get($data['id']);
		$totalprice = MenuOrder::countTotalPrice($menu) + 12500;
		$kurir = Kurir::joinNamaKurir(Kurir::getByOrder($data['id']));
		
		$data['date_detail'] = getdate($data['date']);
		
		Slim::render('admin/obat/view.html',array(
			"order" => $data,
			"customer"=>$customer,
			"store"=>$store,
			"menu"=>$menu,
			"kurir"=>$kurir,
			"totalprice"=>$totalprice
		));
	}
})->name('admin_obat');

/**
 * New obat
 */
Slim::get('/admin/obat/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	$columns = Kunjungan::getColumns();
	Slim::render("admin/obat/new.html",array("columns"=>$columns));
})->name('admin_obat_new');

Slim::post('/admin/obat/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if (Kunjungan::create($_POST)) {
		redir_by_id("obat");
	} else {
		Slim::render('admin/obat/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit obat
 */
Slim::get('/admin/obat/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("obat");
	$data = Kunjungan::get($id);
	Slim::render('admin/obat/edit.html',array(
		"data" => $data
	));
})->name('admin_obat_edit'); 

Slim::post('/admin/obat/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('obat');
	
	if (Kunjungan::update($id,$_POST)) {
		redir_by_id('obat');
	} else {
		Slim::render('admin/obat/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete obat
 */
Slim::get('/admin/obat/del(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('obat');

	Kunjungan::remove($id);
	redir_by_id('obat');
})->name('admin_obat_del');

?>