<?php

/**
 * Show All kunjungan / Show Detail (if kunjungan id is present)
 */
Slim::get('/admin/kunjungan(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) {
		if (isset($_GET['tgl'])) {
			$d = explode('-',$_GET['tgl']);
			$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		} else { $time = time(); }
		
		$data = Kunjungan::getByDate($time);
		
		Slim::render('admin/kunjungan/list.html',array(
			'data' => $data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time),
			'current' => getdate()
		));
	} else {
		$data = Kunjungan::get($id);
		$pasien = Pasien::get($data['id_pasien']);
		$poli = Poli::get($data['id_poli']);
		
		$data['date_detail'] = getdate($data['date']);
		
		Slim::render('admin/kunjungan/view.html',array(
			"order" => $data,
			"pasien"=>$pasien,
			"poli"=>$poli
		));
	}
})->name('admin_kunjungan');

/**
 * New kunjungan
 */
Slim::get('/admin/kunjungan/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	$columns = Kunjungan::getColumns();
	Slim::render("admin/kunjungan/new.html",array("columns"=>$columns));
})->name('admin_kunjungan_new');

Slim::post('/admin/kunjungan/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if (Kunjungan::create($_POST)) {
		redir_by_id("kunjungan");
	} else {
		Slim::render('admin/kunjungan/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit kunjungan
 */
Slim::get('/admin/kunjungan/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("kunjungan");
	$data = Kunjungan::get($id);
	Slim::render('admin/kunjungan/edit.html',array(
		"data" => $data
	));
})->name('admin_kunjungan_edit'); 

Slim::post('/admin/kunjungan/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('kunjungan');
	
	if (Kunjungan::update($id,$_POST)) {
		redir_by_id('kunjungan');
	} else {
		Slim::render('admin/kunjungan/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete kunjungan
 */
Slim::get('/admin/kunjungan/del(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('kunjungan');

	Kunjungan::remove($id);
	redir_by_id('kunjungan');
})->name('admin_kunjungan_del');

?>