<?php

/**
 * Home 
 */

Slim::get('/poli/home',function() {
	User::check_login('poli');
	
	redir_by_id("poli_kunjungan");
})->name('poli_home');

/**
 * Kunjungan
 */

Slim::get('/poli/kunjungan',function() {
	User::check_login('poli');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Kunjungan::getByDatePoli(date("d-m-Y",$time),$_SESSION['user']['id_poli']);
	foreach ($data as $key=>$d) {
		$data[$key]['usia'] = intval(date('Y', time() - strtotime($d["tgl_lahir"]))) - 1970;
		$data[$key]['tgl'] = date("d M Y",$d['tgl']);
		$data[$key]['jam'] = date("H:i",$d['tgl']);
	}
	Slim::render('poli/kunjungan.html',array(
		'data' => $data,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date('F d,Y',$time),
		"tgl_get"=>date("d-m-Y",$time),
		'current' => getdate()
	));
})->name('poli_kunjungan');

/**
 * Periksa
 */

Slim::get('/poli/periksa',function() {
	User::check_login('poli');
	
	if (isset($_GET['idk'])) {
		$data = Kunjungan::get($_GET['idk']);
		$histori = Kunjungan::getListHistori($data['id_pasien']);
		$pasien = Pasien::getById($data['id_pasien']);
		$obat = Obat::getByGol($data['id_golongan']);
		$tindakan = Tindakan::getByPoli($_SESSION['user']['id_poli']);
		$data['golongan'] = Golongan::getNama($data['id_golongan']);
		if ($data['id_ttv'] != null) {
			$ttv = Ttv::get($data['id_ttv']);
		} else {
			$ttv = null;
		}
		
		foreach ($tindakan as $key=>$d) {
			if ($data['golongan'] == 1) {
				$tindakan[$key]['harga_jual'] = $d['d'];
			} elseif ($data['golongan'] == 2) {
				$tindakan[$key]['harga_jual'] = $d['k'];
			} elseif ($data['golongan'] == 3) {
				$tindakan[$key]['harga_jual'] = $d['u'];
			} else {
				$tindakan[$key]['harga_jual'] = $d['m'];
			}
		}
		
		foreach ($obat as $key=>$d) {
			if ($d['status'] == 's') {
				$obat[$key]['harga_jual'] = 0;		// gratiskan obat subsidi
			}
		}
		$pasien['usia'] = intval(date('Y', time() - strtotime($pasien["tgl_lahir"]))) - 1970;
		$data['tanggal'] = date("d M Y",$data['tgl']);
		$data['jam'] = date("H:i",$data['tgl']);
		
		Slim::render('poli/periksa.html',array(
			'data' => $data,
			'pasien' => $pasien,
			'obat' => $obat,
			'tindakan' => $tindakan,
			'histori' => $histori,
			'ttv' => $ttv
		));
	} else {
		redir_by_id('poli_kunjungan');
	}
})->name('poli_periksa');

Slim::post('/poli/periksa',function() {
	User::check_login('poli');

	if(isset($_POST['tindakan'])) {
		foreach ($_POST['tindakan'] as $key=>$tindakan) {
			$m = explode(";",$tindakan);
			KunjunganTindakan::create(array(
				"id_tindakan"=>$m[0],
				"id_kunjungan"=>$_GET['idk'],
				"harga"=>$m[1],
				"jumlah"=>$_POST['jmlt'][$key]
			));
		}
	}
	if(isset($_POST['obat'])) {
		foreach ($_POST['obat'] as $key=>$obat) {
			$m = explode(";",$obat);
			ObatKeluarDetail::create(array(
				"id_obat"=>$m[0],
				"id_kunjungan"=>$_GET['idk'],
				"harga"=>$m[1],
				"jumlah"=>$_POST['jmlo'][$key]
			));
		}
	}

	if (Kunjungan::updateStatus($_GET['idk'],array("status"=>"ambil obat","id_dokter"=>$_SESSION['user']['id']))) {
		redir_by_id('poli_kunjungan');
	} else {
		redir_by_id('poli_periksa',array(),'?idk='.$_GET['idk']);
	}
});

/**
 * Kunjungan histori
 */

Slim::get('/poli/histori',function() {
	User::check_login('poli');
	
	if (isset($_GET['idk'])) {
		$data = Kunjungan::getFull($_GET['idk']);
		// $pasien = Pasien::getById($data['id_pasien']);
		$obat = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
		$tindakan = KunjunganTindakan::getByKunjungan($_GET['idk']);
		if ($data['id_ttv'] != null) {
			$ttv = Ttv::get($data['id_ttv']);
		} else {
			$ttv = null;
		}
		
		$data['pasien']['usia'] = intval(date('Y', time() - strtotime($data['pasien']['tgl_lahir']))) - 1970;
		$data['tanggal'] = date("d M Y",$data['tgl']);
		$data['jam'] = date("H:i",$data['tgl']);
		
		Slim::render('poli/histori.html',array(
			'data' => $data,
			'obat' => $obat,
			'tindakan' => $tindakan,
			'ttv' => $ttv
		));
	} else {
		echo "Maaf, data tidak ditemukan.";
	}
})->name('poli_histori');

?>