<?php

/**
 * Report - Kunjungan Rekap
 */

Slim::get('/bendahara/kunjungan/rekap',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['monthly_month'])) {
		$bln = Rumus::addZero($_GET['monthly_month']);
		$thn = $_GET['monthly_year'];
		$time = $bln."-".$thn;
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	$data = Report::kunjungan($time);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_kunjungan_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/kunjungan/rekapxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/kunjungan/rekap.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn
		));
	}
})->name('bendahara_kunjungan_rekap');

/**
 * Report - Kunjungan Harian
 */

Slim::get('/bendahara/kunjungan/harian',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Report::kunjunganHarian(date("d-m-Y",$time));
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_kunjungan_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/harianxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/kunjungan/harian.html',array(
			"data"=>$data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time)
		));
	}
})->name('bendahara_kunjungan_harian');

?>