<?php

/**
 * Home 
 */

Slim::get('/bendahara/home',function() {
	User::check_login('bendahara');
	
	redir_by_id("bendahara_keuangan_jurnalumum");
})->name('bendahara_home');

/**
 * Jurnal Umum
 */

Slim::get('/bendahara/keuangan/jurnalumum',function() {
	User::check_login('bendahara');
	
	$msg = $_SESSION['msg'];
	$_SESSION['msg'] = "";
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$utime = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		$time = Rumus::addZeroDate($_GET['tgl']);
	} else {
		$utime = time();
		$time = date("d-m-Y",time());
	}
	
	$data = Transaksi::getByDateSumber($time);
	foreach ($data as $k=>$d) {
		$data[$k]['detail'] = TransaksiAkun::getByTransaksi($d['id']);
	}
	$akun = Akun::getByBidang("bendahara");
	$jenisAkun = JenisAkun::getAll();
	
	Slim::render("bendahara/keuangan/jurnalumum.html",array(
		"data"=>$data,
		"akun"=>$akun,
		"jenisAkun"=>$jenisAkun,
		"msg"=>$msg,
		"tgl"=>date("d-M-Y",$utime),
		"tgl_js"=>date("F d,Y",$utime),
		"tgl_get"=>date("d-m-Y",$utime)
	));
})->name('bendahara_keuangan_jurnalumum');

Slim::post('/bendahara/keuangan/jurnalumum',function() {
	User::check_login('bendahara');
	
	if ($_POST['id_trans'] == "") {	// transaksi baru
		$data['no_transaksi'] = $_POST['nomorTransaksi'];
		$data['tgl'] = $_POST['tgl'];
		$data['uraian'] = $_POST['uraian'];
		$data['sumber'] = "bendahara";
		$data['id_user'] = $_SESSION['user']['id'];
		$idt = Transaksi::create($data);
		$_SESSION['msg'] = "Data berhasil ditambahkan";
	} else {	// edit transaksi
		$idt = $_POST['id_trans'];
		$data = Transaksi::get($idt);
		$data['no_transaksi'] = $_POST['nomorTransaksi'];
		$data['tgl'] = $_POST['tgl'];
		$data['uraian'] = $_POST['uraian'];
		$data['id_user'] = $_SESSION['user']['id'];
		Transaksi::update($idt,$data);
		TransaksiAkun::deleteByTransaksi($idt);
		$_SESSION['msg'] = "Update berhasil";
	}
	
	if ($idt > 0) {
		foreach ($_POST['akun'] as $key=>$d) {
			$debit = Rumus::idrToInt($_POST['nominalDebit'][$key]);
			$kredit = Rumus::idrToInt($_POST['nominalKredit'][$key]);
			if ($debit*1 > 0 or $kredit*1 > 0) {
				TransaksiAkun::create(array(	// create transaksi akun
					"id_transaksi"=>$idt,
					"id_akun"=>$d,
					"debit"=>$debit,
					"kredit"=>$kredit
				));
			}
		}
		redir_by_id("bendahara_keuangan_jurnalumum",array(),'?tgl='.$_POST['tgl']);
	} else {
		redir_by_id("bendahara_keuangan_jurnalumum",array(),'?tgl='.$_GET['tgl']);
	}
});

/**
 * Jurnal Donasi
 */

Slim::get('/bendahara/keuangan/jurnaldonasi',function() {
	User::check_login('bendahara');
	
	$msg = $_SESSION['msg'];
	$_SESSION['msg'] = "";
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$utime = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		$time = Rumus::addZeroDate($_GET['tgl']);
	} else {
		$utime = time();
		$time = date("d-m-Y",time());
	}
	
	$data = Transaksi::getByDateSumber($time,"donasi");
	$donatur = Donatur::getAll();
	
	Slim::render("bendahara/keuangan/jurnaldonasi.html",array(
		"data"=>$data,
		"msg"=>$msg,
		"donatur"=>$donatur,
		"tgl"=>date("d-M-Y",$utime),
		"tgl_js"=>date("F d,Y",$utime),
		"tgl_get"=>date("d-m-Y",$utime)
	));
})->name('bendahara_keuangan_jurnaldonasi');

Slim::post('/bendahara/keuangan/jurnaldonasi',function() {
	User::check_login('bendahara');
	
	$idt = 0;
	if ($_POST['donaturNew'] != "") {
		$idd = Donatur::create(array(
			"nama"=>$_POST['donaturNew'],
			"jenis"=>"umum"
		));
	} else {
		$idd = $_POST['idDonatur'];
	}
	$donatur = Donatur::getNama($idd);
	if ($_POST['id_trans'] == "") {	// transaksi baru
		$data['no_transaksi'] = $_POST['nomorTransaksi'];
		$data['tgl'] = $_POST['tgl'];
		$data['uraian'] = "Donasi dari ".$donatur;
		$data['sumber'] = "donasi";
		$data['id_sumber'] = $idd;
		$data['id_user'] = $_SESSION['user']['id'];
		$idt = Transaksi::create($data);
		$_SESSION['msg'] = "Data berhasil ditambahkan";
	} else {	// edit transaksi
		$idt = $_POST['id_trans'];
		$data = Transaksi::get($idt);
		$data['no_transaksi'] = $_POST['nomorTransaksi'];
		$data['tgl'] = $_POST['tgl'];
		$data['uraian'] = "Donasi dari ".$donatur;
		$data['id_sumber'] = $idd;
		$data['id_user'] = $_SESSION['user']['id'];
		Transaksi::update($idt,$data);
		TransaksiAkun::deleteByTransaksi($idt);
		$_SESSION['msg'] = "Update berhasil";
	}
	
	if ($idt > 0) {
		TransaksiAkun::create(array(	// create transaksi debit
			"id_transaksi"=>$idt,
			"id_akun"=>$_POST['akun'],
			"debit"=>Rumus::idrToInt($_POST['nominal']),
			"kredit"=>0
		));
		TransaksiAkun::create(array(	// create transaksi kredit
			"id_transaksi"=>$idt,
			"id_akun"=>21,
			"debit"=>0,
			"kredit"=>Rumus::idrToInt($_POST['nominal'])
		));
		redir_by_id("bendahara_keuangan_jurnaldonasi",array(),'?tgl='.$_POST['tgl']);
	} else {
		redir_by_id("bendahara_keuangan_jurnaldonasi",array(),'?tgl='.$_GET['tgl']);
	}
});

/**
 * Bendahara Get Nomor Transaksi - Ajax
 */

Slim::get('/bendahara/getnomor',function() {
	User::check_login('bendahara');
	
	$tgl = date("d-m-Y",time());
	$data = Transaksi::generateNomorTransaksi("bendahara",$tgl);

	echo json_encode($data);
})->name('bendahara_keuangan_getnomor');

/**
 * Bendahara Get Transaksi - Ajax
 */

Slim::get('/bendahara/gettransaksi',function() {
	User::check_login('bendahara');
	
	$data = Transaksi::get($_GET['id']);
	$akun = TransaksiAkun::getByTransaksi($_GET['id']);
	foreach ($akun as $k=>$a) {
		$akun[$k]['debit'] = Rumus::intToIdr($a['debit'],2);
		$akun[$k]['kredit'] = Rumus::intToIdr($a['kredit'],2);
	}
	$data['akun'] = $akun;

	echo json_encode($data);
})->name('bendahara_keuangan_gettransaksi');

/**
 * Bendahara Get Donasi - Ajax
 */

Slim::get('/bendahara/getdonasi',function() {
	User::check_login('bendahara');
	
	$data = Transaksi::get($_GET['id']);
	$akun = TransaksiAkun::getByTransaksi($_GET['id']);
	foreach ($akun as $k=>$a) {
		if ($a['id_akun'] != 21) {
			$data['akun'] = $a['id_akun'];
			$data['nominal'] = Rumus::intToIdr($a['debit'],2);
		}
	}

	echo json_encode($data);
})->name('bendahara_keuangan_getdonasi');

/**
 * Delete Transaksi - Ajax
 */
 
Slim::get('/bendahara/keuangan/deltransaksi',function() {
	User::check_login('bendahara');
	// User::check_permit('edit','pasien');

	Transaksi::delete($_GET['id']);
	$_SESSION['msg'] = "data berhasil dihapus";
	echo json_encode("success");
})->name('bendahara_keuangan_deltransaksi');

/**
 * Laporan Neraca Percobaan
 */

Slim::get('/bendahara/keuangan/neracapercobaan',function() {
	User::check_login('bendahara');
	
	$tahunBuku = TahunBuku::getAktif();
	$data = Report::neracaPercobaan($tahunBuku['tahun']);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_PEMASUKAN_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/keuangan/neracapercobaan.html',array(
			"data"=>$data,
			"tahun"=>$tahunBuku['tahun']
		));
	}
})->name('bendahara_keuangan_neracapercobaan');

/**
 * Laporan Neraca
 */

Slim::get('/bendahara/keuangan/neraca',function() {
	User::check_login('bendahara');
	
	$listTahun = TahunBuku::getAll();
	if (isset($_GET['tahun'])) {
		$tahun = $_GET['tahun'];
	} else {
		$t = TahunBuku::getAktif();
		$tahun = $t['tahun'];
	}
	$data = Report::neraca($tahun);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_PEMASUKAN_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/keuangan/neraca.html',array(
			"data"=>$data,
			"tahun"=>$tahun,
			"listTahun"=>$listTahun
		));
	}
})->name('bendahara_keuangan_neraca');

/**
 * Laporan Buku Besar
 */

Slim::get('/bendahara/keuangan/bukubesar',function() {
	User::check_login('bendahara');
	
	$akun = Akun::getByBidang("bendahara");
	$jenisAkun = JenisAkun::getAll();
	$tahun = TahunBuku::getAktif();
	$listTahun = TahunBuku::getAll();
	
	if (isset($_GET['tanggal'])) {
		$bentuk = "harian";
	} elseif (isset($_GET['bulan'])) {
		$bentuk = "bulanan";
	} else {
		$bentuk = "tahunan";
	}
	$idAkun = (isset($_GET['idakun']) ? $_GET['idakun'] : 2);
	$tgl['tahun'] = (isset($_GET['tahun']) ? $_GET['tahun'] : $tahun['tahun']);
	$tgl['bulan'] = (isset($_GET['bulan']) ? $_GET['bulan'] : date("m",time()));
	$tgl['tanggal'] = (isset($_GET['tanggal']) ? $_GET['tanggal'] : date("d",time()));
	
	$data = Report::bukuBesar($bentuk,$idAkun,$tgl);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_PEMASUKAN_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/keuangan/bukubesar.html',array(
			"data"=>$data,
			"akun"=>$akun,
			"jenisAkun"=>$jenisAkun,
			"listTahun"=>$listTahun,
			"bentuk"=>$bentuk,
			"idAkun"=>$idAkun,
			"tgl"=>$tgl
		));
	}
})->name('bendahara_keuangan_bukubesar');

/**
 * Laporan Laba/Rugi
 */

Slim::get('/bendahara/keuangan/labarugi',function() {
	User::check_login('bendahara');

	$listTahun = TahunBuku::getAll();
	if (isset($_GET['tahun'])) {
		$tahun = $_GET['tahun'];
	} else {
		$t = TahunBuku::getAktif();
		$tahun = $t['tahun'];
	}
	if (isset($_GET['bulan'])) {
		$bulan = $_GET['bulan'];
	} else {
		$bulan = 0;
	}
	
	$data = Report::labarugi($tahun,$bulan);
	$grandtotal = 0;
	
	foreach ($data as $k=>$d) {
		if ($d['normal'] == 'kredit') {
			$grandtotal += $d['total'];
		} else {
			$grandtotal -= $d['total'];
		}
	}
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_PEMASUKAN_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/keuangan/labarugi.html',array(
			"data"=>$data,
			"grandtotal"=>$grandtotal,
			"listTahun"=>$listTahun,
			"tahun"=>$tahun,
			"bulan"=>$bulan
		));
	}
})->name('bendahara_keuangan_labarugi');

/**
 * Setting Akun
 */

Slim::get('/bendahara/keuangan/akun',function() {
	User::check_login('bendahara');

	if (isset($_GET['idj'])) {
		$idj = $_GET['idj'];
	} else {
		$idj = 1;
	}
	
	$data = Akun::getByJenis($idj);
	$listJenis = JenisAkun::getAll();
	$jenis = JenisAkun::get($idj);
	
	Slim::render("bendahara/keuangan/akun.html",array(
		"data"=>$data,
		"listJenis"=>$listJenis,
		"jenis"=>$jenis
	));
})->name('bendahara_keuangan_akun');

Slim::post('/bendahara/keuangan/akun',function() {
	User::check_login('bendahara');
	
	if ($_POST['id_akun'] > 0) {
		$data = Akun::get($_POST['id_akun']);
	}
	
	$data['kode'] = $_POST['kode'];
	$data['subkode'] = $_POST['subkode'];
	$data['nama'] = $_POST['nama'];
	$data['id_jenis'] = $_POST['id_jenis'];
	$data['normal'] = $_POST['normal'];
	$data['posisi'] = $_POST['posisi'];
	
	if ($_POST['id_akun'] > 0) {
		Akun::update($_POST['id_akun'],$data);
	} else {
		Akun::create($data);
	}

	redir_by_id("bendahara_keuangan_akun",array(),"?idj=".$_POST['id_jenis']);
});

/**
 * Bendahara Get Akun - Ajax
 */

Slim::get('/bendahara/keuangan/getakun',function() {
	User::check_login('bendahara');
	
	$data = Akun::get($_GET['id']);
	
	echo json_encode($data);
})->name('bendahara_keuangan_getakun');

/**
 * Bendahara Hapus Akun
 */

Slim::get('/bendahara/keuangan/delakun(/:id)',function($id = 0) {
	User::check_login('bendahara');
	
	if ($id == 0) redir_by_id("bendahara_keuangan_akun");
	Akun::remove($id);
	redir_by_id("bendahara_keuangan_akun");
})->name('bendahara_keuangan_delakun');

/**
 * Setting Tahun Buku
 */

Slim::get('/bendahara/keuangan/tahunbuku',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Report::pemasukan($time);
	
	Slim::render('bendahara/keuangan/tahunbuku.html',array(
		"data"=>$data,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date('F d,Y',$time),
		"tgl_get"=>date("d-m-Y",$time),
		"current" => getdate()
	));
})->name('bendahara_keuangan_tahunbuku');

/**
 * Setting Saldo Awal
 */

Slim::get('/bendahara/keuangan/saldoawal',function() {
	User::check_login('bendahara');
	
	$msg = $_SESSION['msg'];
	$_SESSION['msg'] = "";
	
	$data = Akun::getSaldoAwal(0,"neraca");
	$jenis = JenisAkun::getByPosisi("neraca");
	foreach ($data as $k=>$d) {
		$data[$k]['awal'] = Rumus::intToIdr($d['awal'],2);
	}
	
	Slim::render('bendahara/keuangan/saldoawal.html',array(
		"data"=>$data,
		"jenis"=>$jenis,
		"msg"=>$msg
	));
})->name('bendahara_keuangan_saldoawal');

Slim::post('/bendahara/keuangan/saldoawal',function() {
	User::check_login('bendahara');

	$data = Akun::getSaldoAwal();
	
	foreach ($data as $k=>$d) {
		if (isset($_POST[$d['id']])) {
			$saldo = Rumus::idrToInt($_POST[$d['id']]);
			Akun::update($d['id'],array("awal"=>$saldo));
		}
	}
	$_SESSION['msg'] = "Data berhasil disimpan";
	
	redir_by_id("bendahara_keuangan_saldoawal");
});

/**
 * migrasi transaksi
 */

Slim::get('/bendahara/keuangan/migrasi',function() {
	User::check_login('bendahara');
	
	$msg = $_SESSION['msg'];
	$_SESSION['msg'] = "";
	
	Slim::render('bendahara/keuangan/migrasi.html');
})->name('bendahara_keuangan_migrasi');

Slim::post('/bendahara/keuangan/migrasi',function() {
	User::check_login('bendahara');

	Transaksi::migrasi();
	Transaksi::regenerateNomorTransaksi();

	$_SESSION['msg'] = "Data berhasil disimpan";
	
	redir_by_id("bendahara_keuangan_migrasi");
});
?>