<?php

/**
 * Report - Gaji Dokter
 */

Slim::get('/bendahara/gaji/dokter',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['monthly_month'])) {
		$bln = Rumus::addZero($_GET['monthly_month']);
		$thn = $_GET['monthly_year'];
		$time = $bln."-".$thn;
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	$data = Report::gajiDokter($time);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_GAJI_DOKTER_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/gaji/gajidokter.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn
		));
	}
})->name('bendahara_gaji_dokter');

/**
 * Report - Gaji Dokter Detail
 */

Slim::get('/bendahara/gaji/dokterdetail',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['bulan'])) {
		$bln = substr($_GET['bulan'],0,2);
		$thn = substr($_GET['bulan'],3,4);
		$time = $_GET['bulan'];
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	if (isset($_GET['dokter'])) {
		$dokter = $_GET['dokter'];
	} else {
		$dokter = 0;
	}
	$userDokter = User::get($dokter);
	$namaDokter = Profil::getNama($userDokter['id_profil']);
	
	$data = Report::gajiDokterDetail($time,$dokter);
	$total = 0;
	foreach ($data as $d) {
		$total += $d['total'];
	}
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_GAJI_DOKTER_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gajidokterxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/gaji/gajidokterdetail.html',array(
			"data"=>$data,
			"dokter"=>$namaDokter,
			"bln"=>$bln*1,
			"thn"=>$thn,
			"tgl"=>$time,
			"total"=>$total
		));
	}
})->name('bendahara_gaji_dokterdetail');

/**
 * Report - Gaji Karyawan
 */

Slim::get('/bendahara/gaji/karyawan',function() {
	User::check_login('bendahara');
	
	$data = Report::gajiDokterDetail($time,$dokter);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_GAJI_DOKTER_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/karyawanxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/gaji/karyawan.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn
		));
	}
})->name('bendahara_gaji_karyawan');

/**
 * Report - Gaji Marketing
 */

Slim::get('/bendahara/gaji/marketing',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['monthly_month'])) {
		$bln = Rumus::addZero($_GET['monthly_month']);
		$thn = $_GET['monthly_year'];
		$time = $bln."-".$thn;
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	if (isset($_GET['dokter'])) {
		$dokter = $_GET['dokter'];
	} else {
		$dokter = 0;
	}
	
	$data = Report::gajiDokterDetail($time,$dokter);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_GAJI_DOKTER_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gaji/marketingxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/gaji/marketing.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn
		));
	}
})->name('bendahara_gaji_marketing');

/**
 * Report - Gaji Saham
 */

Slim::get('/bendahara/gaji/saham',function() {
	User::check_login('bendahara');
	
	if (isset($_GET['monthly_month'])) {
		$bln = Rumus::addZero($_GET['monthly_month']);
		$thn = $_GET['monthly_year'];
		$time = $bln."-".$thn;
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	if (isset($_GET['dokter'])) {
		$dokter = $_GET['dokter'];
	} else {
		$dokter = 0;
	}
	
	$data = Report::gajiDokterDetail($time,$dokter);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_GAJI_DOKTER_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("bendahara/gaji/sahamxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('bendahara/gaji/saham.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn
		));
	}
})->name('bendahara_gaji_saham');

?>