<?php

/**
 * Show All penjualan / Show Detail 
 */
 
Slim::get('/apotek/penjualan/list(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		$find = (isset($_GET['find']) ? $_GET['find'] : "");
		$data = Obat::getByKriteria($current_page,$count_per_page,$find);
		$page = Obat::generatePageKriteria($current_page,$count_per_page,Slim::urlfor("apotek_penjualan_list"),$find);
		$hal = count($page);
		// foreach ($data as $d=>$t) {
			// $data[$d]["age"] = intval(date('Y', time() - strtotime($t["tgl_lahir"]))) - 1970;
			// $data[$d]["tgl_lahir"] = Rumus::reverseDate($t["tgl_lahir"]);
		// }
		
		Slim::render('apotek/penjualan/list.html',array(
			'page' => $page,
			'data' => $data,
			'find' => $find,
			'hal' => $hal
		));
	} else {
		$data = Obat::get($id);
		Slim::render('apotek/penjualan/view.html',array(
			"data" => $data
		));
	}
})->name('apotek_penjualan_list');

/**
 * New penjualan
 */
 
Slim::get('/apotek/penjualan/new/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$columns = Obat::getColumns();
	Slim::render("apotek/penjualan/new.html",array("columns"=>$columns));
})->name('apotek_penjualan_new');

Slim::post('/apotek/penjualan/new/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if (Obat::create($_POST)) {
		redir_by_id("apotek_penjualan_list");
	} else {
		Slim::render('apotek/penjualan/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit penjualan
 */

Slim::get('/apotek/penjualan/edit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("penjualan");
	$data = Obat::get($id);
	Slim::render('apotek/penjualan/edit.html',array(
		"data" => $data
	));
})->name('apotek_penjualan_edit'); 

Slim::post('/apotek/penjualan/edit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('penjualan');
	
	if (Obat::update($id,$_POST)) {
		redir_by_id('apotek_penjualan_list');
	} else {
		Slim::render('apotek/penjualan/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Remove penjualan
 */

Slim::get('/apotek/penjualan/del(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_penjualan_list');

	Obat::remove($id);
	redir_by_id('apotek_penjualan_list');
})->name('apotek_penjualan_rem');
?>