<?php

/**
 * Home 
 */

Slim::get('/apotek/home',function() {
	User::check_login('apotek',2);

	if ($_SESSION['user']['akses'] == 2) {
		redir_by_id('apotek_obat_penjualan');
	} else {
		$obat = Report::getStockObat();
		$menipis = 0;
		$habis = 0;
		foreach ($obat as $o) {
			if ($o['jumlah'] == 0) {
				$habis++;
			} elseif ($o['jumlah'] < 10) {
				$menipis++;
			}
		}
		
		// jumlah obat
		$data['jumlahObat'] = count($obat);
		
		// Penjualan bulan ini
		$data['penjualanBulan'] = Report::totalPenjualan(date("Y-m",time()));
		
		// Penjualan hari ini
		$data['penjualanHari'] = Report::totalPenjualan(date("Y-m-d",time()));
		
		// Stock menipis
		$data['stockMenipis'] = $menipis;
		
		// Hutang belanja
		$data['hutangBelanja'] = Report::totalHutangBelanja();
		
		// Hampir expired
		
		
		// Belanja bulan ini
		$data['belanjaBulan'] = Report::belanjaBulan(date("Y-m",time()));
		
		// Stock habis
		$data['stockHabis'] = $habis;
		
		Slim::render('apotek/obat/home.html',array(
			'data' => $data
		));
	}	
})->name('apotek_home');

/**
 * Info Obat
 */

Slim::get('/apotek/obat/info',function() {
	User::check_login('apotek',2);
	
	$data = Obat::getAll();
	Slim::render('apotek/obat/info.html',array(
		'data' => $data
	));
})->name('apotek_obat_info');

/**
 * Satuan
 */
 
Slim::get('/apotek/obat/satuan',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = Satuan::getAll();
	Slim::render("apotek/obat/satuan.html",array("data"=>$data));
})->name('apotek_obat_satuan');

Slim::post('/apotek/obat/satuan',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['nama'] == "") {
		redir_by_id("apotek_obat_satuan");
	}
	
	if ($_POST['id_satuan'] == "") {
		Satuan::create($_POST);
	} else {
		$data = Satuan::get($_POST['id_satuan']);
		foreach ($_POST as $k=>$p) {
			$data[$k] = $p;
		}
		Satuan::update($_POST['id_satuan'],$data);
	}
	redir_by_id("apotek_obat_satuan");
});

/**
 * Get Satuan - Ajax
 */

Slim::get('/apotek/obat/getsatuan',function() {
	User::check_login('apotek');
	
	$data = Satuan::get($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getsatuan');

/**
 * Remove Satuan
 */

Slim::get('/apotek/obat/remsatuan(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_satuan');

	Satuan::remove($id);
	redir_by_id('apotek_obat_satuan');
})->name('apotek_obat_remsatuan');

/**
 * Kategori Obat
 */
 
Slim::get('/apotek/obat/kategori',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = KategoriObat::getAll();
	Slim::render("apotek/obat/kategori.html",array("data"=>$data));
})->name('apotek_obat_kategori');

Slim::post('/apotek/obat/kategori',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['nama'] == "") {
		redir_by_id("apotek_obat_kategori");
	}
	
	if ($_POST['id_kategori'] == "") {
		Kategori::create($_POST);
	} else {
		$data = Kategori::get($_POST['id_kategori']);
		foreach ($_POST as $k=>$p) {
			$data[$k] = $p;
		}
		Kategori::update($_POST['id_kategori'],$data);
	}
	redir_by_id("apotek_obat_kategori");
});

/**
 * Get Kategori Obat - Ajax
 */

Slim::get('/apotek/obat/getkategori',function() {
	User::check_login('apotek');
	
	$data = KategoriObat::get($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getkategori');

/**
 * Remove Kategori
 */

Slim::get('/apotek/obat/remkategori(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_kategori');

	KategoriObat::remove($id);
	redir_by_id('apotek_obat_kategori');
})->name('apotek_obat_remkategori');

/**
 * Generic Obat
 */
 
Slim::get('/apotek/obat/generic',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = GenericObat::getAll();
	Slim::render("apotek/obat/generic.html",array("data"=>$data));
})->name('apotek_obat_generic');

Slim::post('/apotek/obat/generic',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['nama'] == "") {
		redir_by_id("apotek_obat_generic");
	}
	
	if ($_POST['id_generic'] == "") {
		GenericObat::create($_POST);
	} else {
		$data = GenericObat::get($_POST['id_generic']);
		foreach ($_POST as $k=>$p) {
			$data[$k] = $p;
		}
		GenericObat::update($_POST['id_generic'],$data);
	}
	redir_by_id("apotek_obat_generic");
});

/**
 * Get Generic Obat - Ajax
 */

Slim::get('/apotek/obat/getgeneric',function() {
	User::check_login('apotek');
	
	$data = GenericObat::get($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getgeneric');

/**
 * Remove Generic
 */

Slim::get('/apotek/obat/remgeneric(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_generic');

	GenericObat::remove($id);
	redir_by_id('apotek_obat_generic');
})->name('apotek_obat_remgeneric');

/**
 * Show All obat
 */
 
Slim::get('/apotek/obat/obat',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = Obat::getFull();
	$kategori = KategoriObat::getAll();
	$generic = GenericObat::getAll();
	$satuan = Satuan::getAll();
	
	Slim::render('apotek/obat/obat.html',array(
		'data' => $data,
		'kategori' => $kategori,
		'generic' => $generic,
		'satuan'=> $satuan
	));
})->name('apotek_obat_obat');

Slim::post('/apotek/obat/obat',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['nama'] == "") {
		redir_by_id("apotek_obat_obat");
	}
	
	if ($_POST['id_obat'] == "") {
		Obat::create($_POST);
	} else {
		$data = Obat::get($_POST['id_obat']);
		foreach ($_POST as $k=>$p) {
			$data[$k] = $p;
		}
		Obat::update($_POST['id_obat'],$data);
	}
	redir_by_id("apotek_obat_obat");
});

/**
 * Get Data Obat - Ajax
 */

Slim::get('/apotek/obat/getobat',function() {
	User::check_login('apotek');
	
	$data = Obat::get($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getobat');

/**
 * Get Obat Used - Ajax
 */

Slim::get('/apotek/obat/getused',function() {
	User::check_login('apotek');
	
	$data = Obat::cekUsed($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getused');

/**
 * Remove obat
 */

Slim::get('/apotek/obat/remobat(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_obat');

	$masuk = ObatMasuk::cekUsed($id);
	$keluar = ObatKeluar::cekUsed($id);
	$used = $masuk + $keluar;
	if ($used == 0) {
		Obat::remove($id);
	}
	redir_by_id('apotek_obat_obat');
})->name('apotek_obat_remobat');

/**
 * Delete obat
 */

Slim::get('/apotek/obat/del(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_obat');

	$used = ObatKeluar::cekHistory($id);
	if (!$used) {
		Obat::delete($id);
	}
	
	redir_by_id('apotek_obat_obat');
})->name('apotek_obat_del');

/**
 * Pemasok
 */
 
Slim::get('/apotek/obat/pemasok',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = Pemasok::getAll();
	Slim::render("apotek/obat/pemasok.html",array("data"=>$data));
})->name('apotek_obat_pemasok');

Slim::post('/apotek/obat/pemasok',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['nama'] == "") {
		redir_by_id("apotek_obat_pemasok");
	}
	
	if ($_POST['id_pemasok'] == "") {
		Pemasok::create($_POST);
	} else {
		$data = Pemasok::get($_POST['id_pemasok']);
		foreach ($_POST as $k=>$p) {
			$data[$k] = $p;
		}
		Pemasok::update($_POST['id_pemasok'],$data);
	}
	redir_by_id("apotek_obat_pemasok");
});

/**
 * Get Pemasok Obat - Ajax
 */

Slim::get('/apotek/obat/getpemasok',function() {
	User::check_login('apotek');
	
	$data = Pemasok::get($_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getpemasok');

/**
 * Remove Pemasok
 */

Slim::get('/apotek/obat/rempemasok(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_pemasok');

	Pemasok::remove($id);
	redir_by_id('apotek_obat_pemasok');
})->name('apotek_obat_rempemasok');

/**
 * Obat masuk
 */

Slim::get('/apotek/obat/masuk',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if (isset($_GET['bulan'])) {
		$time = $_GET['tahun']."-".$_GET['bulan'];
	} else {
		$time = date("Y-m");
	}
	$data = ObatMasuk::getByDate($time);
	foreach ($data as $k=>$d) {
		$data[$k]['tgl'] = Rumus::reverseDate($d['tgl']);
		$data[$k]['exp'] = Rumus::reverseDate($d['exp']);
		$data[$k]['obat'] = Obat::getFull($d['id_obat']);
		$data[$k]['pemasok'] = Pemasok::getNama($d['id_pemasok']);
	}
	$listTahun = ObatMasuk::getTahun();
	$pemasok = Pemasok::getAll();
	$obat = Obat::getFull();

	if (isset($_GET['xls'])) {
		ReportExcel::obatMasuk($data,$_GET['bulan']."-".$_GET['tahun']);
	} else {
		Slim::render('apotek/obat/masuk.html',array(
			'data' => $data,
			'obat' => $obat,
			'pemasok' => $pemasok,
			'listTahun' => $listTahun,
			'time' => $time,
			"tgl"=>date("d-m-Y",time()),
			"tgl_js"=>date("F d,Y",time())
		));
	}
})->name('apotek_obat_masuk');

Slim::post('/apotek/obat/masuk',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['id_obat'] == "") {
		redir_by_id("apotek_obat_masuk");
	}
	$tmp = $_POST;
	$tmp['tgl'] = Rumus::reverseDate($_POST['tgl']);
	$tmp['exp'] = Rumus::reverseDate($_POST['exp']);
	
	if ($_POST['id_masuk'] == "") {
		ObatMasuk::create($tmp);
	} else {
		$data = ObatMasuk::get($tmp['id_masuk']);
		foreach ($tmp as $k=>$t) {
			$data[$k] = $t;
		}
		ObatMasuk::update($tmp['id_masuk'],$data);
	}
	redir_by_id("apotek_obat_masuk");
});

/**
 * Get Obat Masuk - Ajax
 */

Slim::get('/apotek/obat/getmasuk',function() {
	User::check_login('apotek');
	
	$data = ObatMasuk::get($_GET['id']);
	$data['tgl'] = Rumus::reverseDate($data['tgl']);
	$data['exp'] = Rumus::reverseDate($data['exp']);

	echo json_encode($data);
})->name('apotek_obat_getmasuk');

/**
 * Obat Masuk Delete
 */

Slim::get('/apotek/obat/masukdel(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_masuk');

	ObatMasuk::remove($id);
	redir_by_id('apotek_obat_masuk');
})->name('apotek_obat_remmasuk');

/**
 * Obat keluar
 */

Slim::get('/apotek/obat/keluar',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if (isset($_GET['bulan'])) {
		$time = $_GET['tahun']."-".$_GET['bulan'];
	} else {
		$time = date("Y-m");
	}
	$data = ObatKeluar::getByDate($time);
	foreach ($data as $k=>$d) {
		$data[$k]['tgl'] = Rumus::reverseDate($d['tgl']);
		$o = Obat::getFull($d['id_obat']);
		if (count($o) == 0) {
			$data[$k]['nama'] = "";
			$data[$k]['kecil'] = "";
		} else {
			$data[$k]['nama'] = $o[0]['nama'];
			$data[$k]['kecil'] = $o[0]['kecil'];
		}	
	}
	$listTahun = ObatKeluar::getTahun();
	$stock = Report::getStockObat();
	
	if (isset($_GET['xls'])) {
		ReportExcel::obatKeluar($data,$_GET['bulan']."-".$_GET['tahun']);
	} else {
		Slim::render('apotek/obat/keluar.html',array(
			'data' => $data,
			'obat' => $stock,
			'listTahun' => $listTahun,
			'time' => $time,
			"tgl"=>date("d-m-Y",time()),
			"tgl_js"=>date("F d,Y",time())
		));
	}
})->name('apotek_obat_keluar');

Slim::post('/apotek/obat/keluar',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($_POST['id_obat'] == "") {
		redir_by_id("apotek_obat_keluar");
	}
	$tmp = $_POST;
	$tmp['tgl'] = Rumus::reverseDate($_POST['tgl']);
	
	if ($_POST['id_keluar'] == "") {
		ObatKeluar::create($tmp);
	} else {
		$data = ObatKeluar::get($tmp['id_keluar']);
		foreach ($tmp as $k=>$t) {
			$data[$k] = $t;
		}
		ObatMasuk::update($tmp['id_keluar'],$data);
	}
	redir_by_id("apotek_obat_keluar");
});

/**
 * Get Obat Keluar - Ajax
 */

Slim::get('/apotek/obat/getkeluar',function() {
	User::check_login('apotek');
	
	$data = ObatKeluar::get($_GET['id']);
	$data['tgl'] = Rumus::reverseDate($data['tgl']);
	// $data['exp'] = Rumus::reverseDate($data['exp']);

	echo json_encode($data);
})->name('apotek_obat_getkeluar');

/**
 * Obat Keluar Delete
 */

Slim::get('/apotek/obat/remkeluar(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_keluar');

	ObatKeluar::remove($id);
	redir_by_id('apotek_obat_keluar');
})->name('apotek_obat_remkeluar');

/**
 * Obat stock akhir
 */

Slim::get('/apotek/obat/stock',function() {
	User::check_login('apotek',2);
	//User::check_permit('edit','order');

	if (isset($_GET['xls'])) {
		$data = report::getStockLengkap();
		ReportExcel::stockObat($data,date("d-m-Y",time()));
	} else {
		$data = report::getStockObat();
		Slim::render('apotek/obat/stock.html',array(
			'data' => $data,
		));
	}
})->name('apotek_obat_stock');

/**
 * Pembayaran Pemasok
 */

Slim::get('/apotek/obat/pembayaran',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	
	$data = Transaksi::getBySumber("pemasok");
	if ($data != null) {
		foreach ($data as $k=>$d) {
			$bayar = 0;
			$nominal = 0;
			$akun = TransaksiAkun::getByTransaksi($d['id']);
			foreach ($akun as $a) {
				if ($a['id_akun'] == 2) {
					$bayar = $a['kredit'];
				}
				if ($a['id_akun'] == 29) {
					$nominal = $a['debit'];
				}
			}
			$cicilan = Transaksi::getBySumber("transaksi",$d['id']);
			foreach ($cicilan as $c) {
				$akun = TransaksiAkun::getByTransaksi($c['id']);
				foreach ($akun as $a) {
					if ($a['id_akun'] == 2) {
						$bayar += $a['kredit'];
					}
				}
			}
			$data[$k]['pemasok'] = Pemasok::getNama($d['id_sumber']);
			$data[$k]['nominal'] = $nominal*1;
			$data[$k]['bayar'] = $bayar*1;
			$data[$k]['kurang'] = $data[$k]['nominal'] - $data[$k]['bayar'];
		}
	}
	$pemasok = Pemasok::getAll();
	
	Slim::render('apotek/obat/pembayaran.html',array(
		'data' => $data,
		'pemasok' => $pemasok,
		"tgl"=>date("d-m-Y",time()),
		"tgl_js"=>date("F d,Y",time())
	));
})->name('apotek_obat_pembayaran');

Slim::post('/apotek/obat/pembayaran',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$arr = array(
		"tgl_unix"=>"",
		"no_transaksi"=>$_POST['no_transaksi'],
		"uraian"=>"Pembayaran Obat kepada ".Pemasok::getNama($_POST['id_pemasok']),
		"nominal"=>$_POST['nominal'],
		"sumber"=>"pemasok",
		"id_sumber"=>$_POST['id_pemasok'],
		"id_user"=>$_SESSION['user']['id']
	);
	
	if ($_POST['id_transaksi'] == "") {		// pembayaran baru
		foreach ($_POST['tgl'] as $k=>$t) {	// create semua transaksi
			if ($k > 0) {					// ganti sumber untuk transaksi selanjutnya
				$arr['sumber'] = "transaksi";
				$arr['id_sumber'] = $idTransUtama;
				$arr['no_transaksi'] = $_POST['faktur'][$k];
			}
			$arr['tgl_unix'] = strtotime($t);
			$id = Transaksi::create($arr);
			if ($k == 0) {					// transaksi utama
				$idTransUtama = $id;
				$akunDebit = 29;
				$akunkredit = 2;
				$nominalDebit = $_POST['nominal'];
				if ($_POST['nominal'] > $_POST['bayar'][0]) {	// cek & bikin transaksi hutang
					TransaksiAkun::create(array(
						"id_transaksi" => $id,
						"id_akun" => 17,
						"kredit" => $_POST['nominal'] - $_POST['bayar'][0]
					));
				}
			} else {						// akun untuk transaksi selanjutnya
				$akunDebit = 17;
				$akunkredit = 2;
				$nominalDebit = $_POST['bayar'][$k];
			}
			TransaksiAkun::create(array(
				"id_transaksi" => $id,
				"id_akun" => $akunDebit,
				"debit" => $nominalDebit
			));
			TransaksiAkun::create(array(
				"id_transaksi" => $id,
				"id_akun" => 2,
				"kredit" => $_POST['bayar'][$k]
			));
		}
	} else {			// edit pembayaran
		foreach ($_POST['idt'] as $k=>$d) {
			$arr['tgl_unix'] = strtotime($_POST['tgl'][$k]);
			if ($k > 0) {
				$arr['sumber'] = "transaksi";
				$arr['id_sumber'] = $_POST['id_transaksi'];
				$arr['no_transaksi'] = $_POST['faktur'][$k];
			}
			if ($d != "") {		// transaksi lama
				$data = Transaksi::get($d);
				foreach ($arr as $k2=>$t) {
					$data[$k2] = $t;
				}
				Transaksi::update($data['id'],$data);
				$id = $data['id'];
			} else {			// transaksi baru
				$id = Transaksi::create($arr);
			}
			TransaksiAkun::deleteByTransaksi($id);
			if ($k == 0) {		// transaksi utama tambah akun hutang jika ada
				$idTransUtama = $id;
				$akunDebit = 29;
				$akunkredit = 2;
				$nominalDebit = $_POST['nominal'];
				if ($_POST['nominal'] > $_POST['bayar'][0]) {
					TransaksiAkun::create(array(
						"id_transaksi" => $id,
						"id_akun" => 17,
						"kredit" => $_POST['nominal'] - $_POST['bayar'][0]
					));
				}
			} else {
				$akunDebit = 17;
				$akunkredit = 2;
				$nominalDebit = $_POST['bayar'][$k]*1;
			}
			TransaksiAkun::create(array(	// create debit
				"id_transaksi" => $id,
				"id_akun" => $akunDebit,
				"debit" => $nominalDebit
			));
			TransaksiAkun::create(array(	// create kredit
				"id_transaksi" => $id,
				"id_akun" => 2,
				"kredit" => $_POST['bayar'][$k]*1
			));
		}
		$id = $_POST['id_transaksi'];
		$obat1 = ObatMasuk::getBySumber("transaksi",$_POST['id_transaksi']);
		foreach ($obat1 as $k=>$o) {		//reset selected obatmasuk
			$obat2 = ObatMasuk::get($o['id']);
			$obat2['sumber'] = null;
			$obat2['id_sumber'] = null;
			ObatMasuk::update($obat2['id'],$obat2);
		}
	}
	
	if (isset($_POST['ids'])) {
		foreach ($_POST['ids'] as $k=>$d) {		//update list obat masuk yg dibayar
			$data2 = ObatMasuk::get($d);
			$data2['sumber'] = "transaksi";
			$data2['id_sumber'] = $idTransUtama;
			ObatMasuk::update($data2['id'],$data2);
		}
	}
	
	redir_by_id("apotek_obat_pembayaran");
});

/**
 * Load List Obat Masuk Untuk Pembayaran
 */

Slim::get('/apotek/obat/getlistmasuk',function() {
	User::check_login('apotek');
	
	$data = ObatMasuk::getByPembayaran($_GET['id'],$_GET['idt']);
	foreach($data as $k=>$d) {
		$data[$k]['tgl'] = Rumus::reverseDate($d['tgl']);
		$data[$k]['total'] = $d['harga_beli']*$d['jumlah'];
	}

	// echo json_encode($data);
	Slim::render('apotek/obat/loadlistmasuk.html',array(
		'data' => $data
	));
})->name('apotek_obat_loadlistmasuk');

/**
 * Get Pembayaran - Ajax
 */

Slim::get('/apotek/obat/getpembayaran',function() {
	User::check_login('apotek');
	
	$data = Transaksi::get($_GET['id']);		// transaksi utama
	$data['tgl'] = date("d-m-Y",$data['tgl_unix']);
	$akun = TransaksiAkun::getByTransaksi($_GET['id']);
	foreach ($akun as $a) {
		if ($a['id_akun'] == 2) {
			$data['bayar'] = $a['kredit']*1;
		}
	}

	$data['cicilan'] = Transaksi::getBySumber("transaksi",$_GET['id']);	// transaksi cicilan
	foreach ($data['cicilan'] as $k=>$d) {
		$akun = TransaksiAkun::getByTransaksi($d['id']);
		foreach ($akun as $k2=>$a2) {
			if ($a2['id_akun'] == 2) {
				$data['cicilan'][$k]['bayar'] = $a2['kredit']*1;
			}
		}
	}

	echo json_encode($data);
})->name('apotek_obat_getpembayaran');

/**
 * Pembayaran Delete
 */

Slim::get('/apotek/obat/rempembayaran(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_obat_pembayaran');

	Transaksi::remove($id);
	Transaksi::deleteBySumber("transaksi",$id);
	redir_by_id('apotek_obat_pembayaran');
})->name('apotek_obat_rempembayaran');

/**
 * Obat Penjualan
 */

Slim::get('/apotek/obat/penjualan',function() {
	User::check_login('apotek',2);
	//User::check_permit('edit','order');

	if (isset($_GET['tgl'])) {
		$tgl_picker = $_GET['tgl'];
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else {
		$tgl_picker = date("d-m-Y",time());
		$time = time();
	}
	
	$faktur = Transaksi::generateNomorTransaksi("penjualan",date("d-m-Y",time()));

	$data = Transaksi::getByDateSumber($tgl_picker,"penjualan");
	foreach ($data as $k=>$d) {
		$data[$k]['obat'] = ObatKeluar::getBySumber("transaksi",$d['id']);
		foreach ($data[$k]['obat'] as $k2=>$d2) {
			$totalObat = $d2['jumlah']*$d2['harga'];
			if ($d2['tipe_diskon'] == 1) {
				$diskonObat = $totalObat * $d2['diskon'] / 100;
			} else {
				$diskonObat = $d2['diskon'];
			}
			$data[$k]['obat'][$k2]['total'] = $totalObat - $diskonObat;
		}
		$akun = TransaksiAkun::getByTransaksi($d['id']);
		foreach ($akun as $ka=>$a) {
			// if ($a['debit'] > 0) {
				switch ($a['id_akun']) {
					case 3:
						$bayar = "cash";
						break;
					case 5:
						$bayar = "trf Mandiri";
						break;
					case 6:
						$bayar = "trf BCA";
						break;
					case 46:
						$bayar = "QRIS";
						break;
				}
			// }
		}
		$data[$k]['jenisPembayaran'] = $bayar;
		$data[$k]['total'] = $akun[0]['debit'] + $akun[0]['kredit'];
	}
	
	$total = Report::totalPenjualan(date("Y-m-d",$time));
	$stock = Report::getStockObat();
	foreach ($stock as $k=>$s) {
		$stock[$k]['harga'] = ObatMasuk::getHargaJual($s['id_obat']);
	}
	
	if (isset($_GET['xls'])) {
		ReportExcel::penjualanHarian($data,$_GET['tgl'],$total);
	} else {
		Slim::render('apotek/obat/penjualan.html',array(
			'data' => $data,
			'obat' => $stock,
			'total' => $total,
			'no_transaksi' => $faktur,
			'tgl_picker' => $tgl_picker,
			'tgl_js_picker'=>date("F d,Y",$time),
			'tgl'=>date("d-m-Y",time()),
			'tgl_js'=>date("F d,Y",time())
		));
	}
})->name('apotek_obat_penjualan');

Slim::post('/apotek/obat/penjualan',function() {
	User::check_login('apotek',2);
	// User::check_permit('edit','order');

	if ($_POST['tgl'] == date("d-m-Y")) {
		$tgl = time();
	} else {
		$tgl = strtotime($_POST['tgl']." ".date('H:i'));
	}
	
	$dataTransaksi = array(
		"tgl_unix"=>$tgl,
		"no_transaksi"=>$_POST['nomor'],
		"uraian"=>"Penjualan Obat",
		"nominal"=>Rumus::idrToInt($_POST['bayar']),	//kolom nominal dipakai untuk uang yg dibayar
		"sumber"=>"penjualan",
		"diskon"=>$_POST['diskon2'],
		"tipe_diskon"=>$_POST['tipeDiskon2'],
		"id_user"=>$_SESSION['user']['id']
	);
	
	$id = 0;
	if ($_POST['id_transaksi'] == "") {				//transaksi baru
		$idTransaksi = Transaksi::create($dataTransaksi);
	} else {										// transaksi lama
		$data = Transaksi::get($_POST['id_transaksi']);
		foreach ($dataTransaksi as $k=>$d) {
			$data[$k] = $d;
		}
		Transaksi::update($data['id'],$data);
		$idTransaksi = $_POST['id_transaksi'];
		ObatKeluar::deleteBySumber("transaksi",$id_transaksi);	//hapus obat keluar
		TransaksiAkun::deleteByTransaksi($id_transaksi);
	}
	
	$id_akun = $_POST['jenisPembayaran'];
	
	TransaksiAkun::create(array(
		"id_transaksi" => $idTransaksi,
		"id_akun" => $id_akun,
		"debit" => $_POST['total2']
	));
	TransaksiAkun::create(array(
		"id_transaksi" => $idTransaksi,
		"id_akun" => 26,
		"kredit" => $_POST['total2']
	));
	
	foreach ($_POST['listObat'] as $k=>$d) {		//create obat keluar
		$tmp = explode(";",$d);
		ObatKeluar::create(array(
			"id_obat" => $tmp[0],
			"tgl" => Rumus::reverseDate($_POST['tgl']),
			"sumber" => "transaksi",
			"id_sumber" => $idTransaksi,
			"harga" => $tmp[1],
			"diskon" => $_POST['diskon'][$k],
			"tipe_diskon" => $_POST['tipeDiskon'][$k],
			"jumlah" => $_POST['jumlah'][$k]
		));
	}
	
	redir_by_id("apotek_obat_penjualan");
});

/**
 * Get Penjualan - Ajax
 */

Slim::get('/apotek/obat/getpenjualan',function() {
	User::check_login('apotek',2);
	
	$data = Transaksi::get($_GET['id']);		// transaksi utama
	$data['obat'] = ObatKeluar::getBySumber("transaksi",$_GET['id']);

	echo json_encode($data);
})->name('apotek_obat_getpenjualan');

/**
 * Penjualan Delete - Ajax
 */

Slim::get('/apotek/obat/rempenjualan',function() {
	User::check_login('apotek',2);
	//User::check_permit('edit','order');

	Transaksi::remove($_GET['id']);
	ObatKeluar::deleteBySumber("transaksi",$_GET['id']);
	echo json_encode("Data berhasil dihapus");
})->name('apotek_obat_rempenjualan');

/**
 * struk Penjualan
 */

Slim::get('/apotek/obat/strukpenjualan',function() {
	User::check_login('apotek',2);

	$data = Transaksi::get($_GET['idt']);
	$akun = TransaksiAkun::getByTransaksi($_GET['idt']);
	foreach ($akun as $k=>$a) {
		if ($a['debit'] > 0) {
			switch ($a['id_akun']) {
				case 3:
					$data['jenisPembayaran'] = "cash";
					break;
				case 5:
					$data['jenisPembayaran'] = "trf Mandiri";
					break;
				case 6:
					$data['jenisPembayaran'] = "trf BCA";
					break;
				case 46:
					$data['jenisPembayaran'] = "QRIS";
					break;
			}
		}
	}
	
	$obat = ObatKeluar::getBySumber("transaksi",$_GET['idt']);
	$total = 0;
	foreach ($obat as $k=>$o) {
		$obat[$k]['subTotal'] = $o['harga'] * $o['jumlah'];
		if ($o['tipe_diskon'] == 1) {
			$disc = $obat[$k]['subTotal'] * $o['diskon'] / 100;
		} else {
			$disc = $o['diskon'];
		}
		$obat[$k]['subTotal2'] = $obat[$k]['subTotal'] - $disc;
		$total += $obat[$k]['subTotal2'];
	}
	
	if ($data['tipe_diskon'] == 1) {
		$disc = $total * $data['diskon'] / 100;
	} else {
		$disc = $data['diskon'];
	}
	$total2 = $total - $disc;
	
	$kembali = $data['nominal'] - $total2;
	
	Slim::render('apotek/obat/struk.html',array(
		"data" => $data,
		"obat" => $obat,
		"total" => $total,
		"total2" => $total2,
		"kembali" => $kembali
	));
})->name('apotek_obat_strukpenjualan');

/**
 * Obat Data Penjualan
 */

Slim::get('/apotek/obat/datapenjualan',function() {
	User::check_login('apotek',2);
	//User::check_permit('edit','order');

	if (isset($_GET['tgl_awal'])) {
		$awal = Rumus::reverseDate($_GET['tgl_awal']);
	} else {
		$awal = date("Y-m-d");
	}
	
	if (isset($_GET['tgl_akhir'])) {
		$akhir = Rumus::reverseDate($_GET['tgl_akhir']);
	} else {
		$akhir = date("Y-m-d");
	}

	$total = 0;
	$data = Report::dataPenjualanObat($awal,$akhir);
	foreach ($data as $k=>$d) {
		$total += $d['total'];
	}

	if (isset($_GET['xls'])) {
		ReportExcel::dataPenjualan($data,$_GET['tgl_awal'],$_GET['tgl_akhir'],$total);
	} else {
		Slim::render('apotek/obat/datapenjualan.html',array(
			'data' => $data,
			'total' => $total,
			'awal' => Rumus::reverseDate($awal),
			'akhir' => Rumus::reverseDate($akhir)
		));
	}
})->name('apotek_obat_datapenjualan');

/**
 * Obat stock history
 */

Slim::get('/apotek/obat/stockhistory',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$utime = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		$date = Rumus::addZeroDate($_GET['tgl']);
	} else {
		$utime = time();
		$date = date("d-m-Y",time());
	}
	$data = report::stockObat($date);
})->name('apotek_obat_stock_history');
?>