var daysInMonth = [31,28,31,30,31,30,31,31,30,31,30,31],
    today = new Date(),
    targetDate = new Date(today.getFullYear(), 1, 1); 

// setDate(targetDate);
setYears(5) // set the next five years in dropdown

$(".select-month").change(function() {
  var monthIndex = $(".select-month").val();
  setDays(monthIndex);
});

function setDate(date) {
  setDays(date.getMonth());
  $(".select-day").val(date.getDate());
  $(".select-month").val(date.getMonth());
  $(".select-year").val(date.getFullYear()); 
}

// make sure the number of days correspond with the selected month
function setDays(monthIndex) {
  var optionCount = $('.select-day option').length,
      daysCount = daysInMonth[monthIndex-1];
  
  if (optionCount < daysCount) {
    for (var i = optionCount; i < daysCount; i++) {
      $('.select-day')
        .append($("<option></option>")
        .attr("value", i + 1)
        .text(i + 1)); 
    }
  }
  else {
    for (var i = daysCount; i < optionCount; i++) {
      var optionItem = '.select-day option[value=' + (i+1) + ']';
      $(optionItem).remove();
    } 
  } 
}

function setYears(val) {
  var year = today.getFullYear();
  for (var i = 0; i < val; i++) {
      $('.select-year')
        .append($("<option></option>")
        .attr("value", year + i)
        .text(year + i)); 
    }
}