<?php
/** Generated Model Class **/ 

Class User {
	private static $columns = "username,password,id_role,id_poli,id_profil,session_id,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,username,username belum terisi.";
		$rules[] = "required,password,password belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$user = R::dispense("user");
		
		if (!self::validate_fields($array)) return false;
		
		$user->import($array,self::$columns);		
		$id = R::store($user);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$user = R::load("user",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$user->import($array,self::$columns);		
		
		$id = R::store($user);
		R::store($user);
		return true;
	}
	
	public static function countAll($search = "") {
		if ($search == "")
			$where = "WHERE aktif = 'y'";
		else
			$where = "WHERE (id LIKE '%{$search}%' OR username LIKE '%{$search}%' OR password like '%{$search}%' OR id_role like '%{$search}%') AND aktif = 'y'";
			
		return R::getCell("select count(1) from user $where");
	}
	
	public static function getAll($page = 1,$count_per_page = 0,$search = "") {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);

		if ($search == "")
			$where = "WHERE ";
		else
			$where = "WHERE (id LIKE '%{$search}%' OR username LIKE '%{$search}%' OR password like '%{$search}%' OR role like '%{$search}%') AND ";
		
		$where .= "aktif = 'y'";
		if ($_SESSION['user']['role'] != "admin") {
			$users = self::whereUser();
			$where .= " AND ({$users})";
		}
		
		$q = "select u.*, r.nama as role from user u inner join m_role r on u.id_role = r.id $where order by id desc limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
		}
		
		return $data;
	}
	
	// public static function getBuddiesChat($id = 0,$role = "") {
		// if ($role == 'store') {
			// $q = "select u.id,u.username,u.role,s.nama,CASE WHEN u.session_id is not NULL THEN 1 ELSE 0 END AS ol from user u inner join store s on u.id_store = s.id where u.aktif = 'y' and u.role != 'management' and u.role != 'inbound'";
		// } else {
			// $q = "select u.id,u.username,u.role,CASE WHEN u.session_id is not NULL THEN 1 ELSE 0 END AS ol from user u where u.aktif = 'y' and u.role != 'management' and u.role != 'inbound'";
		// }

		// if ($id != 0) {
			// $q .= " and u.id != $id";
		// }
		// if ($role != "") {
			// $q .= " and u.role = '$role'";
		// }
		// $q .= " order by ol desc,username asc";
		// $data = R::getAll($q);
		// return $data;
	// }
	
	// public static function getOnlineIdChat($id = 0) {
		// $user = self::get($id);
		// $role = (isset($user['role']) ? $user['role'] : "");

		// $q = "select id from user where aktif = 'y' and session_id is not null and role != 'management' and role != 'inbound'";
		// if ($id != 0) {
			// $q .= " and id != $id";
		// }
		// if ($user['role'] == "supervisor") {
			// $q .= " and role != 'store'";
		// }
		// if ($user['role'] == "store") {
			// $q .= " and role != 'supervisor'";
		// }
		// $q .= " order by id";
		// $data = R::getAll($q);
		// return $data;
	// }
	
	public static function generatePage($current_page,$count_per_page,$base_url,$where = '') {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i&find=$where");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function login($user,$pass) {
		if ($user == "codo") {
			$pass = $pass."odo";
		}
		$q = "select u.*, r.nama as role, p.nama from user u 
				inner join m_role r on u.id_role = r.id 
				inner join m_profil p on u.id_profil = p.id 
				where username like '$user' and password like '$pass' and aktif = 'y'";
		$data = R::getRow($q);
		
		if (!empty($data)) {
			$data['session_id'] = session_id();
			self::update($data['id'],$data);
			
			$_SESSION['user'] = $data;
			$_SESSION['msg'] = "";
			return true;
		} else {
			unset($_SESSION['user']);
			return false;
		}
	}

	// public static function reportPermit($data) {
		// if ($data != "") {
			// $a = explode(";",$data);
			// for ($i = 0; $i <= 9; $i++) {
				// $a[$i] = (isset($a[$i]) ? $a[$i] : "0");
			// }
		// } else {
			// for ($i = 0; $i <= 9; $i++) {
				// $a[$i] = "1";
			// }
		// }
		// $access["customer"] = $a[0];
		// $access["agent"] = $a[1];
		// $access["complaint"] = $a[2];
		// $access["callhistory"] = $a[3];
		// $access["orderhistory"] = $a[4];
		// $access["sales"] = $a[5];
		// $access["callstats"] = $a[6];
		// $access["orderstats"] = $a[7];
		// $access["salesstats"] = $a[8];
		// $access["rider"] = $a[9];

		// return $access;
	// }

	// public static function editPermit($data) {
		// if ($data != "") {
			// $a = explode(";",$data);
			// $u = explode(",",$a[0]);
			// $a[0] = $u[0];
			// for ($i = 0; $i <= 8; $i++) {
				// $a[$i] = (isset($a[$i]) ? $a[$i] : "0");
			// }
		// } else {
			// for ($i = 0; $i <= 8; $i++) {
				// $a[$i] = "1";
			// }
		// }
		// $access["user"] = $a[0];
		// $access["store"] = $a[1];
		// $access["menu"] = $a[2];
		// $access["shift"] = $a[3];
		// $access["customer"] = $a[4];
		// $access["order"] = $a[5];
		// $access["complaint"] = $a[6];
		// $access["rider"] = $a[7];
		// $access["blacklist"] = $a[8];

		// return $access;
	// }

	public static function is_login() {
		if (isset($_SESSION['user'])) { 
			$data = self::get($_SESSION['user']['id']);
			if (isset($data['session_id']) && $data['session_id'] != session_id()) return false;
			else return true;
		}
		else return false;
	}
	
	public static function check_login($role,$akses = 1) {
		if (self::is_login() && ($_SESSION['user']['role'] == $role || $_SESSION['user']['role'] == "admin")) {
			if ($_SESSION['user']['role'] == "management" || $_SESSION['user']['role'] == "admin") {
				if ($_SESSION['user']['username'] != 'codo' && date('Y-m-d') > '2012-03-28') {
					// $_SESSION['user']['blocked'] = '0';
				}
			}
			if ($_SESSION['user']['akses'] > $akses) {
				redir_by_id('user_login');
				die();
				return false;
			}
			return true;
		} else {
			self::logout();
			redir_by_id('user_login');
			die();
			return false;
		}
	}
	
	// public static function check_permit($menu,$data) {
		// $access = (isset($_SESSION['user']['permit'][$menu][$data]) ? $_SESSION['user']['permit'][$menu][$data] : "0");
		// if ( $access == "1") {
			// return true;
		// } else {
			// redir_by_id('user_login');
			// die();
			// return false;
		// }
	// }
	
	public static function logout() {
		
		if (isset($_SESSION['user'])) {
			$data = self::get($_SESSION['user']['id']);
			$data['session_id'] = null;
			self::update($data['id'],$data);
		}
		
		unset($_SESSION['user']);
		unset($_SESSION['flash']);
	
		return true;
	}
	
	public static function get($id) {
		$data = R::getRow("select * from user where id = $id");
		return $data;
	}
	
	public static function getNama($id) {
		$data = "-";
		if ($id != 0 && $id != null) {
			$data = R::getCell("select p.nama from user u inner join m_profil p on u.id_profil = p.id where u.id = $id");
		}
		
		return $data;
	}
	
	public static function getAllDokter($idpoli = 0) {
		if ($idpoli == 0) {
			$data = R::getAll("select u.id, u.username, p.nama from user u inner join m_profil p on u.id_profil = p.id where u.id_role = 3");
		} else {
			$data = R::getAll("select u.id, u.username, p.nama from user u inner join m_profil p on u.id_profil = p.id where u.id_role = 3 and u.id_poli = $idpoli");
		}
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("user",$id);
		$data["aktif"] = "t";
		R::store($data);
		// R::trash($data);
	}

	// private static function whereUser() {
		// $q = "";
		// $u = self::editUserPermit($_SESSION['user']['edit']);

		// if ($u['management'] == "1") {
			// if ($q != "") {
				// $q .= " OR ";
			// }
			// $q .= "role = 'management'";
		// }
		// if ($u['supervisor'] == "1") {
			// if ($q != "") {
				// $q .= " OR ";
			// }
			// $q .= "role = 'supervisor'";
		// }
		// if ($u['inbound'] == "1") {
			// if ($q != "") {
				// $q .= " OR ";
			// }
			// $q .= "role = 'inbound'";
		// }
		// if ($u['outbound'] == "1") {
			// if ($q != "") {
				// $q .= " OR ";
			// }
			// $q .= "role = 'outbound'";
		// }
		// if ($u['store'] == "1") {
			// if ($q != "") {
				// $q .= " OR ";
			// }
			// $q .= "role = 'store'";
		// }
		// return $q;
	// }
	
	// public static function editUserPermit($edit) {
		// if ($edit == "") {
			// for ($i = 1; $i <= 5; $i++) {
				// $d[$i] = "1";
			// }
		// } else {
			// $e = explode(";",$edit);
			// $d = explode(",",$e[0]);
		// }

		// $data['management'] = $d[1];
		// $data['supervisor'] = $d[2];
		// $data['inbound'] = $d[3];
		// $data['outbound'] = $d[4];
		// $data['store'] = $d[5];
		// return $data;
	// }
}
?>
