<?php
/** Generated Model Class **/ 

Class TransaksiAkun {    
	private static $columns = "id_transaksi,id_akun,debit,kredit";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$transaksi_akun = R::dispense("transaksi_akun");
		if (!self::validate_fields($array)) return false;
		
		$transaksi_akun->import($array,self::$columns);		
		$id = R::store($transaksi_akun);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$transaksi_akun = R::load("transaksi_akun",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$transaksi_akun->import($array,self::$columns);		
		
		R::store($transaksi_akun);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from transaksi_akun");
	}
		
	public static function getAll($page = 1,$count_per_page = 0) {
		$q = "select * from transaksi_akun";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from transaksi_akun where id = $id");
		return $data;
	}
	
	public static function getSaldo($id,$tgl = "") {
		$whereTgl = "";
		if ($tgl != "") {
			$arrTgl = explode("-",$tgl);
			$revTgl = $arrTgl[2].$arrTgl[1].$arrTgl[0];
			$whereTgl = "AND CONCAT(RIGHT(t.tgl,4),MID(t.tgl,4,2),LEFT(t.tgl,2)) < $revTgl";
		}
		if ($id > 0) {
			$q = "SELECT SUM(debit) AS debit, SUM(kredit) AS kredit FROM transaksi_akun ta
				INNER JOIN transaksi t ON ta.id_transaksi = t.id WHERE id_akun = $id $whereTgl";
			$data = R::getRow($q);
		} else {
			$q = "SELECT a.nama, SUM(debit) AS debit, SUM(kredit) AS kredit FROM transaksi_akun ta
				INNER JOIN akun a ON ta.id_akun = a.id INNER JOIN transaksi t ON ta.id_transaksi = t.id WHERE a.aktif = 'y' $whereTgl";
			$data = R::getAll($q);
		}
		
		return $data;
	}
	
	public static function getByTransaksi($idt) {
		$q = "select ta.*, a.nama from transaksi_akun ta inner join akun a on ta.id_akun = a.id where ta.id_transaksi = $idt";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function delete($id) {
		$data = R::load("transaksi_akun",$id);
		R::trash($data);
	}
	
	public static function deleteByTransaksi($idt = 0) {
		$q = "delete from transaksi_akun where id_transaksi = $idt";
		R::exec($q);
	}
}
?>
