<?php
/** Generated Model Class **/ 

Class Rumus {
	
	public static function diff($start,$end = false) {
		
		// Checks $start and $end format (timestamp only for more simplicity and portability)
		if(!$end) { $end = time(); }
		if(!is_numeric($start) || !is_numeric($end)) { return false; }
		// Convert $start and $end into EN format (ISO 8601)
		$start  = date('Y-m-d H:i:s',$start);
		$end    = date('Y-m-d H:i:s',$end);
		$d_start    = new DateTime($start);
		$d_end      = new DateTime($end);
		$diff = $d_start->diff($d_end);
		$nom = array();
		// return all data
		$nom['year']    = $diff->format('%y');
		$nom['month']    = $diff->format('%m');
		$nom['day']      = $diff->format('%d');
		$nom['hour']     = $diff->format('%H');
		$nom['min']      = $diff->format('%I');
		$nom['sec']      = $diff->format('%S');
		return $nom;
	}
	
	public static function reverseDate($str) {
		$tgl = array();
		$tgl = explode("-",$str);
		if (count($tgl) == 3) {
			$newtgl = $tgl[2]."-".$tgl[1]."-".$tgl[0];
		} elseif (count($tgl) == 2) {
			$newtgl = $tgl[1]."-".$tgl[0];
		} else {
			$newtgl = $str;
		}

		return $newtgl;
	}
	
	public static function addZeroDate($str) {
		$tgl = array();
		$tgl = explode("-",$str);
		$newtgl = self::addZero($tgl[0])."-".self::addZero($tgl[1])."-".$tgl[2];
		
		return $newtgl;
	}
	
	public static function addZero($n) {
		$n *= 1;
		if ($n < 10) return "0" . $n;
		else return $n;
	}
	
	public static function changeDateFormat($tgl) {	// '-' to '/' vice versa
		if (strpos($tgl,"/")) {
			$t = array();
			$t = explode("/",$tgl);
			$data = $t[0]."-".$t[1]."-".$t[2];
		} else {
			$t = array();
			$t = explode("-",$tgl);
			$data = $t[0]."/".$t[1]."/".$t[2];
		}
		return $data;
	}
	
	public static function intToIdr($nominal,$dec = 0) {
		$n = number_format($nominal,$dec,",",".");
		return $n;
	}
	
	public static function idrToInt($nominal) {
		$n = str_replace(",",".",str_replace(".","",$nominal));
		return $n;
	}
}
?>
