<?php
/** Generated Model Class **/ 

Class ObatMasuk {    
	private static $columns = "id_obat,tgl,sumber,id_sumber,id_pemasok,harga_beli,harga_jual,exp,jumlah,keterangan,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$stock = R::dispense("obat_masuk");
		if (!self::validate_fields($array)) return false;
		
		$stock->import($array,self::$columns);		
		$id = R::store($stock);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$stock = R::load("obat_masuk",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$stock->import($array,self::$columns);		
		
		R::store($stock);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from obat_masuk");
	}
		
	public static function getAll() {
		$q = "select * from obat_masuk order by id desc";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function getByKriteria($page = 1,$count_per_page = 0,$kriteria = "",$status = "") {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		
		$where = "";
		if ($status == "expired") {
			$where = "AND keluar > 0";
		}
		$q = "select s.*, o.nama from obat_masuk s 
				INNER JOIN m_obat o ON s.id_obat = o.id 
				where (o.nama like '%".$kriteria."%' or o.kode like '%".$kriteria."%' or s.batch like '%".$kriteria."%' or s.pbf like '%".$kriteria."%') $where 
				order by s.tgl_beli desc limit $start_record,$count_per_page";
		$data = R::getAll($q); 
		return $data;
	}
	
	public static function countAllKriteria($kriteria = "",$status = "") {
		$where = "";
		if ($status == "expired") {
			$where = "AND keluar > 0";
		}
		return R::getCell("SELECT count(1) FROM obat_masuk s INNER JOIN m_obat o ON s.id_obat = o.id 
							WHERE (o.nama LIKE '%".$kriteria."%' or o.kode LIKE '%".$kriteria."%' or s.batch LIKE '%".$kriteria."%' or s.pbf LIKE '%".$kriteria."%') $where");
	}
	
	public static function generatePageKriteria($current_page,$count_per_page,$base_url,$kriteria = "",$status = "") {
		$total_page = ceil(self::countAllKriteria($kriteria,$status)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			if ($kriteria == "") {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
			} else {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?find=".$kriteria."&p=$i");
			}
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select s.*, o.nama from obat_masuk s inner join m_obat o on s.id_obat = o.id where s.id = $id");
		return $data;
	}
	
	public static function getByDate($date = "") { // Y-m
		if ($date == "") {
			$date = date("Y-m");
		}
		
		if (substr($date,-2) == "00") {
			$date = substr($date,0,4);
			$where = "where LEFT(tgl,4) = '$date'";
		} else {
			$where = "where LEFT(tgl,7) = '$date'";
		}
		
		$data = R::getAll("select * from obat_masuk $where");
		return $data;
	}
	
	public static function getByPemasok($id) {
		$data = R::getAll("SELECT om.*,o.nama FROM obat_masuk om INNER JOIN m_obat o ON om.id_obat = o.id where om.id_pemasok = $id");
		return $data;
	}
	
	public static function getBySumber($sumber,$id = 0) {
		if ($id == 0 || $id == "" ) {
			$where = "";
		} else {
			$where = "AND id_sumber = $id";
		}
		$data = R::getAll("SELECT * FROM obat_masuk WHERE sumber = '$sumber' $where");
		return $data;
	}
	
	public static function getByPembayaran($idPemasok,$id = 0) {	// get list obat masuk by id pemasok dan id transaksi
		if ($id == 0 || $id == "" ) {
			$qTrans = "";
		} else {
			$qTrans = "UNION 
						SELECT om2.*,o2.nama FROM obat_masuk om2 
						INNER JOIN m_obat o2 ON om2.id_obat = o2.id 
						WHERE om2.id_pemasok = $idPemasok AND om2.sumber = 'transaksi' AND om2.id_sumber = $id";
		}
		$q = "SELECT om.*,o.nama FROM obat_masuk om 
				INNER JOIN m_obat o ON om.id_obat = o.id 
				WHERE om.id_pemasok = $idPemasok AND om.sumber is null $qTrans";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getHargaJual($id) {
		$data = R::getCell("SELECT harga_jual FROM obat_masuk WHERE id_obat = $id ORDER BY tgl desc LIMIT 1");
		return $data;
	}
	
	public static function getTahun() {
		$data = R::getAll("select year(tgl) as tahun from obat_masuk GROUP BY tahun ORDER BY tahun");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("obat_masuk",$id);
		R::trash($data);
	}
	
	public static function cekUsed($ido) {
		$data = R::getCell("SELECT count(*) FROM obat_masuk WHERE id_obat = $ido");
		return $data;
	}
}
?>
