<?php
/** Generated Model Class **/ 

Class ObatKeluar {    
	private static $columns = "id_obat,tgl,sumber,id_sumber,harga,diskon,tipe_diskon,jumlah,keterangan";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$obat_keluar = R::dispense("obat_keluar");
		if (!self::validate_fields($array)) return false;
		
		$obat_keluar->import($array,self::$columns);		
		$id = R::store($obat_keluar);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$obat_keluar = R::load("obat_keluar",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$obat_keluar->import($array,self::$columns);		
		
		R::store($obat_keluar);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from obat_keluar");
	}
		
	public static function getAll($page = 1,$count_per_page = 0) {
		$q = "select * from obat_keluar";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("SELECT * FROM obat_keluar WHERE id = $id");
		return $data;
	}
	
	public static function getBySumber($sumber,$ids = 0) {
		$w = "";
		if ($ids > 0) {
			$w = "AND ok.id_sumber = $ids";
		}
		$q = "SELECT ok.*, o.nama FROM obat_keluar ok INNER JOIN m_obat o ON ok.id_obat = o.id WHERE ok.sumber = '$sumber' $w";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getPenjualan($tgl,$ids = 0) {
		$w = "";
		if ($ids > 0) {
			$w = "AND ok.id_sumber = $ids";
		}
		$q = "SELECT ok.*, o.nama FROM obat_keluar ok INNER JOIN m_obat o ON ok.id_obat = o.id WHERE ok.sumber = 'penjualan' $w";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByDate($date = "") {	// Y-m
		if ($date == "") {
			$date = date("Y-m");
		}
		
		if (substr($date,-2) == "00") {
			$date = substr($date,0,4);
			$where = "where LEFT(tgl,4) = '$date'";
		} else {
			$where = "where LEFT(tgl,7) = '$date'";
		}
		
		$data = R::getAll("select * from obat_keluar $where");
		return $data;
	}
	
	public static function getTahun() {
		$data = R::getAll("select year(tgl) as tahun from obat_keluar GROUP BY tahun ORDER BY tahun");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("obat_keluar",$id);
		R::trash($data);
	}
	
	public static function deleteBySumber($sumber,$ids) {
		$q = "DELETE FROM obat_keluar WHERE id_sumber = $ids AND sumber = '$sumber'";
		R::exec($q);
	}
	
	public static function cekUsed($ido) {
		$data = R::getCell("SELECT count(*) FROM obat_keluar WHERE id_obat = $ido");
		return $data;
	}
}
?>
