<?php

/**
 * Show All tindakan / Show Detail (if tindakan id is present)
 */
Slim::get('/admin/tindakan(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) {
		if (isset($_GET['tgl'])) {
			$d = explode('-',$_GET['tgl']);
			$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		} else { $time = time(); }
		
		$data = Kunjungan::getByDate($time);
		
		Slim::render('admin/tindakan/list.html',array(
			'data' => $data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time),
			'current' => getdate()
		));
	} else {
		$data = Kunjungan::get($id);
		$customer = Customer::get($data['id_customer']);
		$store = Store::get($data['id_store']);
		$menu = MenuOrder::get($data['id']);
		$totalprice = MenuOrder::countTotalPrice($menu) + 12500;
		$kurir = Kurir::joinNamaKurir(Kurir::getByOrder($data['id']));
		
		$data['date_detail'] = getdate($data['date']);
		
		Slim::render('admin/tindakan/view.html',array(
			"order" => $data,
			"customer"=>$customer,
			"store"=>$store,
			"menu"=>$menu,
			"kurir"=>$kurir,
			"totalprice"=>$totalprice
		));
	}
})->name('admin_tindakan');

/**
 * New tindakan
 */
Slim::get('/admin/tindakan/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	$columns = Kunjungan::getColumns();
	Slim::render("admin/tindakan/new.html",array("columns"=>$columns));
})->name('admin_tindakan_new');

Slim::post('/admin/tindakan/new/',function() {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if (Kunjungan::create($_POST)) {
		redir_by_id("tindakan");
	} else {
		Slim::render('admin/tindakan/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit tindakan
 */
Slim::get('/admin/tindakan/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("tindakan");
	$data = Kunjungan::get($id);
	Slim::render('admin/tindakan/edit.html',array(
		"data" => $data
	));
})->name('admin_tindakan_edit'); 

Slim::post('/admin/tindakan/edit(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('tindakan');
	
	if (Kunjungan::update($id,$_POST)) {
		redir_by_id('tindakan');
	} else {
		Slim::render('admin/tindakan/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete tindakan
 */
Slim::get('/admin/tindakan/del(/:id)',function($id = 0) {
	User::check_login('admin');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('tindakan');

	Kunjungan::remove($id);
	redir_by_id('tindakan');
})->name('admin_tindakan_del');

?>