<?php

/**
 * registrasi Home
 */
 
Slim::get('/registrasi/home',function() {
	User::check_login('registrasi');
	
	redir_by_id("registrasi_administrasi_pasien");
})->name('registrasi_home');

/**
 * Show All pasien / Show Detail (if pasien id is present)
 */
 
Slim::get('/registrasi/administrasi/pasien/(:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		$find = (isset($_GET['find']) ? $_GET['find'] : "");
		$poli = Poli::getAll();
		$data = Pasien::getByKriteria($current_page,$count_per_page,$find);
		$page = Pasien::generatePageKriteria($current_page,$count_per_page,Slim::urlfor("registrasi_administrasi_pasien"),$find);
		$hal = count($page);
		foreach ($data as $d=>$t) {
			$data[$d]["age"] = intval(date('Y', time() - strtotime($t["tgl_lahir"]))) - 1970;
			$data[$d]["tgl_lahir"] = Rumus::reverseDate($t["tgl_lahir"]);
		}
		
		Slim::render('registrasi/administrasi/pasienlist.html',array(
			'page' => $page,
			'data' => $data,
			'poli' => $poli,
			'find' => $find,
			'hal' => $hal
		));
	} else {
		$data = Pasien::get($id);
		Slim::render('registrasi/administrasi/pasienview.html',array(
			"data" => $data
		));
	}
})->name('registrasi_administrasi_pasien');

Slim::post('/registrasi/administrasi/pasien/',function() {	// Daftarkan pasien ke kunjungan baru
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	$antrian = Kunjungan::getAntrian($_POST['poli']);
	$p = Pasien::get($_POST['id_pasien']);
	$idk = Kunjungan::create(array(
		"no_kunjungan"=>$antrian,
		"id_pasien"=>$_POST['id_pasien'],
		"id_golongan"=>$p['id_golongan'],
		"tgl"=>time(),
		"id_poli"=>$_POST['poli'],
		"id_resepsionis"=>$_SESSION['user']['id'],
		"baru"=>$_POST['baru'],
		"status"=>'bayar'
	));
	if ($_POST['baru'] == 'y') {
		SumberBiaya::create(array(
			"sumber"=>"kunjungan",
			"id_sumber"=>$idk,
			"id_biaya"=>1,
			"harga"=>Biaya::getHarga(1)
		));
	}
	redir_by_id("registrasi_administrasi_kunjungan");
});

/**
 * New pasien
 */
 
Slim::get('/registrasi/administrasi/pasienbaru/',function() {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	$columns = Pasien::getColumns();
	$golongan = Golongan::getAll();
	$rm = Pasien::getNewRm();
	Slim::render("registrasi/administrasi/pasiennew.html",array(
		"columns"=>$columns,
		"golongan"=>$golongan,
		"rm"=>$rm
	));
})->name('registrasi_administrasi_pasiennew');

Slim::post('/registrasi/administrasi/pasienbaru/',function() {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	$_POST["tgl_lahir"] = Rumus::reverseDate($_POST["tgl_lahir"]);
	$_POST["nama"] = ucwords(strtolower($_POST["nama"]));
	
	if (Pasien::create($_POST)) {
		redir_by_id("registrasi_administrasi_pasien");
	} else {
		Slim::render('registrasi/administrasi/pasiennew.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit pasien
 */
 
Slim::get('/registrasi/administrasi/pasienedit(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("registrasi_administrasi_pasien");
	$data = Pasien::get($id);
	$data["tgl_lahir"] = Rumus::reverseDate($data["tgl_lahir"]);
	$golongan = Golongan::getAll();
	
	Slim::render('registrasi/administrasi/pasienedit.html',array(
		"data" => $data,
		"golongan"=>$golongan
	));
})->name('registrasi_administrasi_pasienedit');

Slim::post('/registrasi/administrasi/pasienedit(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("registrasi_administrasi_pasien");
	$_POST["tgl_lahir"] = Rumus::reverseDate($_POST["tgl_lahir"]);
	$_POST["nama"] = ucwords(strtolower($_POST["nama"]));
	
	if (Pasien::update($id,$_POST)) {
		redir_by_id("registrasi_administrasi_pasien");
	} else {
		Slim::render('registrasi/administrasi/pasienedit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete pasien
 */
 
Slim::get('/registrasi/administrasi/pasiendel(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("registrasi_administrasi_pasien");

	Pasien::remove($id);
	redir_by_id("registrasi_administrasi_pasiendel");
})->name('registrasi_administrasi_pasiendel');

/**
 * Kunjungan
 */

Slim::get('/registrasi/administrasi/kunjungan',function() {
	User::check_login('registrasi');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Kunjungan::getByDate(date("d-m-Y",$time));
	$biaya = Biaya::getAllAktif();
	foreach ($data as $key=>$d) {
		$data[$key]['tgl'] = date("d M Y",$d['tgl']);
		$data[$key]['jam'] = date("H:i",$d['tgl']);
	}
	foreach ($biaya as $k=>$b) {
		$biaya[$k]['harga'] = Rumus::intToIdr($b['harga']);
	}
	Slim::render('registrasi/administrasi/kunjungan.html',array(
		"data" => $data,
		"biaya" => $biaya,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date("F d,Y",$time),
		"tgl_get"=>date("d-m-Y",$time),
		"current" => getdate()
	));
})->name('registrasi_administrasi_kunjungan');

/**
 * Detail Kunjungan
 */

Slim::get('/registrasi/administrasi/kunjungan(:id)',function($id = 0) {
	User::check_login('registrasi');
	
	if ($id == 0) { redir_by_id('registrasi_administrasi_kunjungan'); die(); }
	
	$data = Kunjungan::get($id);
	
	$pasien = Pasien::get($data['id_pasien']);
	$poli = Poli::get($data['id_poli']);
	$data['date_detail'] = getdate($data['date']);
	
	Slim::render('registrasi/administrasi/kunjungandetail.html',array(
		"order" => $data,
		"pasien"=>$pasien,
		"poli"=>$poli
	));
})->name('registrasi_administrasi_kunjungandetail');

/**
 * Delete kunjungan
 */
 
Slim::get('/registrasi/administrasi/kunjungan/del(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("registrasi_administrasi_kunjungan");

	Kunjungan::delete($id);
	redir_by_id("registrasi_administrasi_kunjungan");
})->name('registrasi_administrasi_kunjungan_del');

/**
 * Administrasi Kunjungan Get Biaya - Ajax
 */

Slim::get('/registrasi/administrasi/kunjungan/getbiaya',function() {
	User::check_login('registrasi');
	
	$data['tindakan'] = KunjunganTindakan::getByKunjungan($_GET['idk']);
	$data['obat'] = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
	$data['biaya'] = SumberBiaya::getBySumber("kunjungan",$_GET['idk']);
	$data['pasien'] = Kunjungan::getFull($_GET['idk']);
	$data['pembayaran'] = Transaksi::getPembayaranKunjungan($_GET['idk']);
	
	$data['hutang'] = Transaksi::getHutang($data['pasien']['id_pasien'],Rumus::changeDateFormat($data['pasien']['tanggal']));
	
	foreach ($data['biaya'] as $k=>$d) {
		$data['biaya'][$k]['harga'] = Rumus::intToIdr($d['harga']);
	}
	foreach ($data['pembayaran'] as $k=>$d) {
		$data['pembayaran'][$k] = Rumus::intToIdr($d);
	}
	
	echo json_encode($data);
})->name('registrasi_administrasi_kunjungan_getbiaya');

/**
 * Administrasi Kunjungan Simpan Biaya - Ajax
 */

Slim::post('/registrasi/administrasi/kunjungan/simpanbiaya',function() {
	User::check_login('registrasi');
	
	$kunjungan = Kunjungan::getFull($_POST['idk']);
	$kredit[25] = $_POST['totalTindakan'];
	$kredit[26] = $_POST['totalObat'];
	
	SumberBiaya::deleteByKunjungan($_POST['idk']);
	if (isset($_POST['idb'])) {
		foreach ($_POST['idb'] as $key=>$b) {
			$harga = Rumus::idrToInt($_POST['harga'][$key]);
			SumberBiaya::create(array(
				"sumber"=>"kunjungan",
				"id_sumber"=>$_POST['idk'],
				"id_biaya"=>$b,
				"harga"=>$harga
			));
			$biaya = Biaya::get($b);
			if (isset($kredit[$biaya['id_akun']])) {
				$kredit[$biaya['id_akun']] += $harga;
			} else {
				$kredit[$biaya['id_akun']] = $harga;
			}
		}
	}
	
	$transaksi = Transaksi::getBySumber("kunjungan",$_POST['idk']);
	$transaksi['tgl'] = Rumus::changeDateFormat($kunjungan['tanggal']);
	$transaksi['uraian'] = "Kunjungan pasien a.n. ".$kunjungan['pasien']['nama'];
	$transaksi['sumber'] = "kunjungan";
	$transaksi['id_sumber'] = $kunjungan['id'];
	$transaksi['id_user'] = $_SESSION['user']['id'];
	if (isset($transaksi['id'])) {
		Transaksi::update($transaksi['id'],$transaksi);
		$idt = $transaksi['id'];
	} else {
		$transaksi['no_transaksi'] = Transaksi::generateNomorTransaksi("kunjungan",$transaksi['tgl']);
		$idt = Transaksi::create($transaksi);
	}
	
	TransaksiAkun::deleteByTransaksi($idt);			// hapus TransaksiAkun
	foreach ($_POST['pembayaran'] as $k => $b) {	// create TransaksiAkun debit
		if ($b != 0 and $b != "") {
			switch ($k) {
				case 0:
					$transaksiAkun['id_akun'] = 3;break;
				case 1:
					$transaksiAkun['id_akun'] = 5;break;
				case 2:
					$transaksiAkun['id_akun'] = 46;break;
				case 3:
					$transaksiAkun['id_akun'] = 8;break;
			}
			$transaksiAkun['id_transaksi'] = $idt;
			$transaksiAkun['debit'] = Rumus::idrToInt($b);
			$transaksiAkun['kredit'] = 0;
			TransaksiAkun::create($transaksiAkun);
		}
	}
	foreach ($kredit as $k => $t) {
		if ($t != 0) {
			$transaksiAkun['id_akun'] = $k;
			$transaksiAkun['id_transaksi'] = $idt;
			$transaksiAkun['debit'] = 0;
			$transaksiAkun['kredit'] = $t;
			TransaksiAkun::create($transaksiAkun);
		}
	}
})->name('registrasi_administrasi_kunjungan_simpanbiaya');

/**
 * Kunjungan Akhir
 */

Slim::get('/registrasi/administrasi/kunjunganakhir',function() {
	User::check_login('registrasi');
	
	Slim::render('registrasi/administrasi/kunjunganakhir.html');
})->name('registrasi_administrasi_kunjunganakhir');

Slim::post('/registrasi/administrasi/kunjunganakhir',function() {
	User::check_login('registrasi');
	
	// $data = Kunjungan::getAkhir();
	
	// foreach ($data as $key=>$d) {
		// $data[$key]['usia'] = intval(date('Y', time() - strtotime($d["tgl_lahir"]))) - 1970;
		// $tindakan = KunjunganTindakan::getByKunjungan($d['id']);
		// foreach ($tindakan as $keyt=>$t) {
			// if (substr($t['nama'],0,10) != "Konsultasi") {
				// if (isset($data[$key]['tindakan'])) {
					// $data[$key]['tindakan'] = $data[$key]['tindakan'].", ".$t['nama'];
				// } else {
					// $data[$key]['tindakan'] = $t['nama'];
				// }
			// }
		// }
	// }
	$cnt = 1;
	$kosong = "";
	$data2 = Kunjungan::getRm();
	foreach ($data2 as $key=>$d) {
		if ($d['no_rekmed']*1 == $cnt) {
			$cnt++;
		} else {
			while($cnt < $d['no_rekmed']) {
				$kosong .= $cnt.",";
				$cnt++;
			}
			$cnt++;
		}
	}
	var_dump($kosong);die();
	// header("Content-type: application/vnd.ms-excel");
	// header("Content-disposition: attachment; filename=KunjunganAkhir.xls"); // filename terserah anda
	// header("Pragma: no-cache");
	// header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
	// header("Expires: 0");
	Slim::render('registrasi/administrasi/kunjunganakhirxls.html',array(
		"data"=>$data
	));
	//redir_by_id('registrasi_administrasi_akhir');
});

/**
 * Penjualan
 */

Slim::get('/registrasi/administrasi/penjualan',function() {
	User::check_login('registrasi');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Penjualan::getByDate(date("d-m-Y",$time));
	$biaya = Biaya::getAllAktif();
	foreach ($data as $key=>$d) {
		$data[$key]['tgl'] = date("d M Y",$d['tgl']);
		$data[$key]['jam'] = date("H:i",$d['tgl']);
	}
	foreach ($biaya as $k=>$b) {
		$biaya[$k]['harga'] = Rumus::intToIdr($b['harga']);
	}
	Slim::render('registrasi/administrasi/penjualan.html',array(
		"data" => $data,
		"biaya" => $biaya,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date("F d,Y",$time),
		"tgl_get"=>date("d-m-Y",$time),
		"current" => getdate()
	));
})->name('registrasi_administrasi_penjualan');

/**
 * Penjualan Get Biaya - Ajax
 */

Slim::get('/registrasi/administrasi/penjualan/getbiaya',function() {
	User::check_login('registrasi');
	$data['tindakan'] = KunjunganTindakan::getByKunjungan($_GET['idk']);
	$data['obat'] = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
	$data['biaya'] = SumberBiaya::getBySumber("kunjungan",$_GET['idk']);
	$data['pasien'] = Kunjungan::getFull($_GET['idk']);
	$data['pembayaran'] = Transaksi::getPembayaranKunjungan($_GET['idk']);
	foreach ($data['biaya'] as $k=>$d) {
		$data['biaya'][$k]['harga'] = Rumus::intToIdr($d['harga']);
	}
	foreach ($data['pembayaran'] as $k=>$d) {
		$data['pembayaran'][$k] = Rumus::intToIdr($d);
	}
	
	echo json_encode($data);
})->name('registrasi_administrasi_penjualan_getbiaya');

/**
 * Penjualan Simpan Biaya - Ajax
 */

Slim::post('/registrasi/administrasi/penjualan/simpanbiaya',function() {
	User::check_login('registrasi');
	
	$penjualanApotek = Kunjungan::getFull($_POST['idk']);
	$kredit[26] = $_POST['totalObat'];
	
	SumberBiaya::deleteByKunjungan("penjualan",$_POST['idk']);
	if (isset($_POST['idb'])) {
		foreach ($_POST['idb'] as $key=>$b) {
			$harga = Rumus::idrToInt($_POST['harga'][$key]);
			SumberBiaya::create(array(
				"sumber"=>"penjualan",
				"id_biaya"=>$b,
				"id_kunjungan"=>$_POST['idk'],
				"harga"=>$harga
			));
			$biaya = Biaya::get($b);
			if (isset($kredit[$biaya['id_akun']])) {
				$kredit[$biaya['id_akun']] += $harga;
			} else {
				$kredit[$biaya['id_akun']] = $harga;
			}
		}
	}
	
	$transaksi = Transaksi::getBySumber("apotek",$_POST['idk']);
	$transaksi['tgl'] = Rumus::changeDateFormat($kunjungan['tanggal']);
	$transaksi['uraian'] = "Penjualan obat untuk ".$kunjungan['pasien']['nama'];
	$transaksi['sumber'] = "penjualan";
	$transaksi['id_sumber'] = $kunjungan['id'];
	$transaksi['id_user'] = $_SESSION['user']['id'];
	if (isset($transaksi['id'])) {
		Transaksi::update($transaksi['id'],$transaksi);
		$idt = $transaksi['id'];
	} else {
		$transaksi['no_transaksi'] = Transaksi::generateNomorTransaksi("kunjungan",$transaksi['tgl']);
		$idt = Transaksi::create($transaksi);
	}
	
	TransaksiAkun::deleteByTransaksi($idt);			// hapus TransaksiAkun
	foreach ($_POST['pembayaran'] as $k => $b) {	// create TransaksiAkun debit
		if ($b != 0 and $b != "") {
			switch ($k) {
				case 0:
					$transaksiAkun['id_akun'] = 3;break;
				case 1:
					$transaksiAkun['id_akun'] = 5;break;
				case 2:
					$transaksiAkun['id_akun'] = 8;break;
			}
			$transaksiAkun['id_transaksi'] = $idt;
			$transaksiAkun['debit'] = Rumus::idrToInt($b);
			$transaksiAkun['kredit'] = 0;
			TransaksiAkun::create($transaksiAkun);
		}
	}
	foreach ($kredit as $k => $t) {
		if ($t != 0) {
			$transaksiAkun['id_akun'] = $k;
			$transaksiAkun['id_transaksi'] = $idt;
			$transaksiAkun['debit'] = 0;
			$transaksiAkun['kredit'] = $t;
			TransaksiAkun::create($transaksiAkun);
		}
	}
})->name('registrasi_administrasi_penjualan_simpanbiaya');

/**
 * Piket
 */

Slim::get('/registrasi/administrasi/piket',function() {
	User::check_login('registrasi');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Piket::getByDate(date("d-m-Y",$time));
	$shift = Shift::getAktif();
	$poli = Poli::getAll();
	foreach ($poli as $k=>$p) {
		$poli[$k]['dokter'] = UserPoli::getByPoli($p['id']);
	}
	
	Slim::render("registrasi/administrasi/piket.html",array(
		"data"=>$data,
		"poli"=>$poli,
		"shift"=>$shift,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date("F d,Y",$time),
		"tgl_get"=>date("d-m-Y",$time)
	));
})->name('registrasi_administrasi_piket');

Slim::post('/registrasi/administrasi/piket',function() {
	User::check_login('registrasi');
	
	Piket::removeByTgl($_POST['tgl']);
	foreach ($_POST['dokter'] as $d) {
		if ($d != "") {
			$data = explode(",",$d);
			$arr['tgl'] = $_POST['tgl'];
			$arr['id_poli'] = $data[0];
			$arr['id_shift'] = $data[1];
			$arr['id_dokter'] = $data[2];
			Piket::create($arr);
		}
	}
	redir_by_id('registrasi_administrasi_piket');
});

/**
 * detail pembayaran
 */

Slim::get('/registrasi/administrasi/pembayaran',function() {
	User::check_login('registrasi');

	$data = Kunjungan::getByStatus("pembayaran");
	
	Slim::render('registrasi/administrasi/pembayaran.html',array(
		"data" => $data,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date('F d,Y',$time),
		"tgl_get"=>date("d-m-Y",$time),
		"current" => getdate()
	));
})->name('registrasi_administrasi_pembayaran');

/**
 * struk Kunjungan
 */

Slim::get('/registrasi/administrasi/strukkunjungan',function() {
	User::check_login('registrasi');

	$data['tindakan'] = KunjunganTindakan::getByKunjungan($_GET['idk']);
	$data['obat'] = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
	$data['biaya'] = SumberBiaya::getBySumber("kunjungan",$_GET['idk']);
	$data['kunjungan'] = Kunjungan::getFull($_GET['idk']);
	$data['pembayaran'] = Transaksi::getPembayaranKunjungan($_GET['idk']);
	
	$data['kunjungan']['gol'] = strtoupper(substr($data['kunjungan']['golongan'],0,1));
	
	$totaltindakan = 0;
	foreach ($data['tindakan'] as $key=>$t) {
		$totaltindakan += $t['harga'] * $t['jumlah'];
		$data['tindakan'][$key]['harga'] = $t['harga'] * $t['jumlah'];
	}
	$totalobat = 0;
	foreach ($data['obat'] as $key=>$o) {
		$totalobat += $o['harga'] * $o['jumlah'];
		$data['obat'][$key]['harga'] = $o['harga'] * $o['jumlah'];
	}
	$totalbiaya = 0;
	foreach ($data['biaya'] as $key=>$b) {
		$totalbiaya += $b['harga'];
	}
	$total = $totaltindakan + $totalbiaya + $totalobat;
	
	Slim::render('registrasi/administrasi/strukkunjungan.html',array(
		"data" => $data,
		"totalobat" => $totalobat,
		"total" => $total
	));
})->name('registrasi_administrasi_kunjungan_struk');

/**
 * struk Penjualan
 */

Slim::get('/registrasi/administrasi/penjualanstruk',function() {
	User::check_login('registrasi');

	$data['obat'] = ObatKeluarDetail::getBySumber("apotek",$_GET['ids']);
	$data['biaya'] = SumberBiaya::getBySumber("apotek",$_GET['ids']);
	$data['penjualan'] = Kunjungan::getFull($_GET['idk']);
	$data['pembayaran'] = Transaksi::getPembayaranPenjualan($_GET['idk']);
	
	$data['kunjungan']['gol'] = strtoupper(substr($data['kunjungan']['golongan'],0,1));
	
	$totaltindakan = 0;
	foreach ($data['tindakan'] as $key=>$t) {
		$totaltindakan += $t['harga'] * $t['jumlah'];
		$data['tindakan'][$key]['harga'] = $t['harga'] * $t['jumlah'];
	}
	$totalobat = 0;
	foreach ($data['obat'] as $key=>$o) {
		$totalobat += $o['harga'] * $o['jumlah'];
		$data['obat'][$key]['harga'] = $o['harga'] * $o['jumlah'];
	}
	$totalbiaya = 0;
	foreach ($data['biaya'] as $key=>$b) {
		$totalbiaya += $b['harga'];
	}
	$total = $totaltindakan + $totalbiaya + $totalobat;
	
	Slim::render('registrasi/administrasi/penjualanstruk.html',array(
		"data" => $data,
		"totalobat" => $totalobat,
		"total" => $total
	));
})->name('registrasi_administrasi_penjualan_struk');
?>