<?php

/**
 * Show All alkes / Show Detail (if alkes id is present)
 */
 
Slim::get('/apotek/alkes/list(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		$find = (isset($_GET['find']) ? $_GET['find'] : "");
		$data = Alkes::getByKriteria($current_page,$count_per_page,$find);
		$page = Alkes::generatePageKriteria($current_page,$count_per_page,Slim::urlfor("apotek_alkes"),$find);
		$hal = count($page);
		// foreach ($data as $d=>$t) {
			// $data[$d]["age"] = intval(date('Y', time() - strtotime($t["tgl_lahir"]))) - 1970;
			// $data[$d]["tgl_lahir"] = Rumus::reverseDate($t["tgl_lahir"]);
		// }
		
		Slim::render('apotek/alkes/list.html',array(
			'page' => $page,
			'data' => $data,
			'find' => $find,
			'hal' => $hal
		));
	} else {
		$data = Alkes::get($id);
		Slim::render('apotek/alkes/view.html',array(
			"data" => $data
		));
	}
})->name('apotek_alkes_list');

/**
 * New alkes
 */
 
Slim::get('/apotek/alkes/new/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$columns = Alkes::getColumns();
	Slim::render("apotek/alkesnew.html",array("columns"=>$columns));
})->name('apotek_alkes_new');

Slim::post('/apotek/alkes/new/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if (Alkes::create($_POST)) {
		redir_by_id("apotek_alkes");
	} else {
		Slim::render('apotek/alkes/new.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit alkes
 */

Slim::get('/apotek/alkes/edit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id("alkes");
	$data = Alkes::get($id);
	Slim::render('apotek/alkes/edit.html',array(
		"data" => $data
	));
})->name('apotek_alkes_edit'); 

Slim::post('/apotek/alkes/edit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('alkes');
	
	if (Alkes::update($id,$_POST)) {
		redir_by_id('apotek_alkes_list');
	} else {
		Slim::render('apotek/alkes/edit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete alkes
 */

Slim::get('/apotek/alkes/del(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_alkes_list');

	Alkes::remove($id);
	redir_by_id('apotek_alkes_list');
})->name('apotek_alkes_del');

/**
 * Alkes masuk
 */

Slim::get('/apotek/alkes/masuk(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) {
		$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
		$count_per_page = 30;
		
		$find = (isset($_GET['find']) ? $_GET['find'] : "");
		$data = AlkesMasuk::getByKriteria($current_page,$count_per_page,$find);
		$page = AlkesMasuk::generatePageKriteria($current_page,$count_per_page,Slim::urlfor("apotek_alkes_masuk"),$find);
		$hal = count($page);
		foreach ($data as $k=>$d) {
			$data[$k]['tgl_beli'] = Rumus::reverseDate($d['tgl_beli']);
		}
		
		Slim::render('apotek/alkes/masuk.html',array(
			'page' => $page,
			'data' => $data,
			'find' => $find,
			'hal' => $hal
		));
	} else {
		$data = AlkesMasuk::get($id);
		Slim::render('apotek/alkes/masukview.html',array(
			"data" => $data
		));
	}
})->name('apotek_alkes_masuk');

/**
 * Alkes Masuk New
 */

Slim::get('/apotek/alkes/masuknew/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$alkes = Alkes::getAll();
	$columns = AlkesMasuk::getColumns();
	Slim::render('apotek/masuknew.html',array(
		"columns"=>$columns,
		"alkes"=>$alkes,
		"tgl"=>date("d-m-Y",time()),
		"tgl_js"=>date("F d,Y",time())
	));
})->name('apotek_alkes_masuknew');

Slim::post('/apotek/masuknew/',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	$data = $_POST;
	if (!is_numeric($data['keluar'])) {
		$data['keluar'] = 0;
	}
	$data['tgl_beli'] = Rumus::reverseDate($data['tgl_beli']);
	$data['exp'] = Rumus::reverseDate($data['exp']);
	if (AlkesMasuk::create($data)) {
		redir_by_id('apotek_stock');
	} else {
		Slim::render('apotek/masuknew.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Edit stock
 */

Slim::get('/apotek/alkes/masukedit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_stock');
	$alkes = Alkes::getAll();
	$data = AlkesMasuk::get($id);
	$data['tgl_beli'] = Rumus::reverseDate($data['tgl_beli']);
	$data['exp'] = Rumus::reverseDate($data['exp']);
	Slim::render('apotek/stockedit.html',array(
		"data" => $data,
		"alkes"=>$alkes,
		"tgl_js"=>date("F d,Y",time())
	));
})->name('apotek_alkes_masukedit'); 

Slim::post('/apotek/alkes/masukedit(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_alkes_masuk');
	
	$data = $_POST;
	if (!is_numeric($data['keluar'])) {
		$data['keluar'] = 0;
	}
	$data['tgl_beli'] = Rumus::reverseDate($data['tgl_beli']);
	$data['exp'] = Rumus::reverseDate($data['exp']);
	if (AlkesMasuk::update($id,$data)) {
		redir_by_id('apotek_alkes_masuk');
	} else {
		Slim::render('apotek/alkes/masukedit.html',array(
			"data" => $_POST
		));
	}
});

/**
 * Delete alkes masuk
 */

Slim::get('/apotek/alkes/masukdel(/:id)',function($id = 0) {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	if ($id == 0) redir_by_id('apotek_alkes_masuk');

	AlkesMasuk::remove($id);
	redir_by_id('apotek_alkes_masuk');
})->name('apotek_alkes_masukdel');

/**
 * Alkes keluar
 */

Slim::get('/apotek/alkes/keluar',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	
})->name('apotek_alkes_keluar');

/**
 * Alkes stock
 */

Slim::get('/apotek/alkes/stock',function() {
	User::check_login('apotek');
	//User::check_permit('edit','order');

	
})->name('apotek_alkes_stock');
?>