<?php
/** Generated Model Class **/ 

Class UserPoli {
	private static $columns = "id_user,id_poli,status";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,id_user,user belum terisi.";
		$rules[] = "required,id_poli,poli belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$user_poli = R::dispense("user_poli");
		
		if (!self::validate_fields($array)) return false;
		
		$user_poli->import($array,self::$columns);		
		$id = R::store($user_poli);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$user_poli = R::load("user_poli",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$user_poli->import($array,self::$columns);		
		
		$id = R::store($user_poli);
		R::store($user_poli);
		return true;
	}
	
	public static function countAll($search = "") {
		if ($search == "")
			$where = "";
		else
			$where = "WHERE (pr.nama LIKE '%{$search}%' OR u.username LIKE '%{$search}%' OR p.nama like '%{$search}%')";
			
		return R::getCell("SELECT count(1) FROM user u 
							INNER JOIN user_poli up ON u.id = up.id_user 
							INNER JOIN m_profil pr ON pr.id = u.id_profil 
							INNER JOIN poli p ON p.id = up.id_poli $where");
	}
	
	public static function getAll($page = 1,$count_per_page = 0,$search = "") {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);

		if ($search == "")
			$where = "";
		else
			$where = "WHERE (pr.nama LIKE '%{$search}%' OR u.username LIKE '%{$search}%' OR p.nama like '%{$search}%')";
		
		$q = "SELECT u.username, pr.nama, p.nama as poli, up.status FROM user u 
				INNER JOIN user_poli up ON u.id = up.id_user 
				INNER JOIN m_profil pr ON pr.id = u.id_profil 
				INNER JOIN poli p ON p.id = up.id_poli $where limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
		}
		
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url,$where = '') {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i&find=$where");
		}
		return  (isset($page) ? $page : array());
	}

	public static function get($id) {
		$data = R::getRow("SELECT * FROM user_poli WHERE id = $id");
		return $data;
	}
	
	public static function getByUser($id) {
		$data = "-";
		
		if ($id != 0 && $id != null) {
			$data = R::getAll("SELECT p.nama, p.status FROM user_poli u 
								INNER JOIN m_poli p ON u.id_poli = p.id 
								WHERE u.id = $id");
		}
		return $data;
	}
	
	public static function getByPoli($id,$status = '') {
		$w = "";
		if ($status != '') {
			$w = "and up.status = '$status'";
		}
		$data = R::getAll("SELECT u.id, pr.nama, up.status FROM user_poli up 
							INNER JOIN user u ON u.id = up.id_user 
							INNER JOIN m_profil pr ON pr.id = u.id_profil 
							WHERE up.id_poli = $id $w");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("user_poli",$id);
		R::trash($data);
	}
}
?>