<?php
/** Generated Model Class **/ 

Class Transaksi {    
	private static $columns = "tgl_unix,no_transaksi,uraian,nominal,sumber,id_sumber,diskon,tipe_diskon,id_user,status";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$transaksi = R::dispense("transaksi");
		if (!self::validate_fields($array)) return false;
		
		$transaksi->import($array,self::$columns);		
		$id = R::store($transaksi);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$transaksi = R::load("transaksi",$id);
		if (!self::validate_fields($array)) return false;
		
		$transaksi->import($array,self::$columns);		
		
		R::store($transaksi);
		return true;
	}	
	
	public static function countAll($search = "") {
		
		if ($search == "")
			$where = "";
		else
			$where = "WHERE name LIKE '%{$search}%' OR alias like '%{$search}%' OR address like '%{$search}%'";
			
		return R::getCell("select count(1) from transaksi $where");
	}
		
	public static function getAll($page = 1,$count_per_page = 0,$search = "",$status = null) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		
		$where = "where status = '$status'";
		if ($status == null) {
			$where = "where status is null";
		}
		if ($search != "") {
			$where .= " and (uraian LIKE '%{$search}%' or kode LIKE '%{$search}%')";
		}
		$q = "select *,CONCAT(RIGHT(tgl,4),MID(tgl,4,2),LEFT(tgl,2)) as tval from transaksi $where order by tval desc limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url,$where = '') {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i&find=$where");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select *, FROM_UNIXTIME(tgl_unix,'%d-%m-%Y') as tgl, FROM_UNIXTIME(tgl_unix,'%H:%i') as jam from transaksi where id = $id");
		
		return $data;
	}
	
	public static function getSaldo($id,$posisi,$tgl="") {
		$t = "";
		if ($tgl != "") {
			$t = "and tgl = '$tgl'";
		}
		$data = R::getCell("select SUM(nominal) from transaksi where id_akun_$posisi = $id and status != 'na' $t");
		if ($data == null) {
			$data = 0;
		}
		return $data;
	}
	
	public static function getHutang($idp = 0, $tgl = "") {
		if ($idp > 0) {
			$where = " AND p.id = $idp";
		}
		if ($tgl != "") {
			$tmp = explode("-",$tgl);
			$t = $tmp[2].$tmp[1].$tmp[0];
			$where .= " AND from_unixtime(k.tgl,'%Y%m%d') < '$t'";
		}
		$q = "SELECT FROM_UNIXTIME(tgl_unix,'%d-%m-%Y') as tgl, ta.debit, ta.kredit FROM transaksi t 
				INNER JOIN transaksi_akun ta ON t.id = ta.id_transaksi 
				INNER JOIN kunjungan k ON k.id = t.id_sumber
				INNER JOIN m_pasien p ON p.id = k.id_pasien
				WHERE ta.id_akun = 8 $where";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByDateSumber($date,$sumber = "") {
		$where = "";
		if ($sumber != "") {
			$where = "AND sumber = '$sumber'";
		}
		$q = "SELECT *, FROM_UNIXTIME(tgl_unix,'%d-%m-%Y') as tgl, FROM_UNIXTIME(tgl_unix,'%H:%i') as jam 
				FROM transaksi WHERE FROM_UNIXTIME(tgl_unix,'%d-%m-%Y') = '$date' AND status <> 'na' $where";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getBySumber($sumber,$ids = 0) {
		if($ids == 0) {
			$where = "WHERE sumber = '$sumber'";
		} else {
			$where = "WHERE sumber = '$sumber' AND id_sumber = $ids";
		}
		$q = "SELECT *, FROM_UNIXTIME(tgl_unix,'%d-%m-%Y') as tgl, FROM_UNIXTIME(tgl_unix,'%H:%i') as jam FROM transaksi $where";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByDateAkun($date,$ida = 0) {
		$where = "";
		if ($ida != 0) {
			if (is_array($ida)) {
				foreach ($ida as $i) {
					if ($where == "") {
						$where = "where id_akun = $i ";
					} else {
						$where .= "or id_akun = $i ";
					}
				}
			} else {
				$where = "where id_akun = $ida ";
			}
		}
		$q = "SELECT t.*, FROM_UNIXTIME(t.tgl_unix,'%d-%m-%Y') as tgl, ta.debit, ta.kredit FROM transaksi t JOIN 
				(select id_transaksi, debit, kredit from transaksi_akun $where) ta 
				on t.id = ta.id_transaksi where FROM_UNIXTIME(t.tgl_unix,'%d-%m-%Y') = '$date' and t.status <> 'na'";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getDonasi($date) {
		$q = "select a.*, d.nama from (select t.*, ta.total_debit, ta.total_kredit from transaksi t inner join 
					(select id_transaksi, sum(debit) as total_debit, sum(kredit) as total_kredit from transaksi_akun group by id_transaksi) ta 
					on t.id = ta.id_transaksi where FROM_UNIXTIME(t.tgl_unix,'%d-%m-%Y') as tgl = '$date' and t.sumber = 'donasi' and t.status <> 'na') a left join 
					donatur d on a.id_sumber = d.id";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getPembayaranKunjungan($idk = 0) {
		$q = "select ta.id_akun, ta.debit as nominal from transaksi t 
				inner join transaksi_akun ta on ta.id_transaksi = t.id 
				where t.sumber = 'kunjungan' and t.id_sumber = $idk and ta.kredit = 0 and t.status != 'na'";
		$d = R::getAll($q);
		
		$data['cash'] = 0;
		$data['transfer'] = 0;
		$data['qris'] = 0;
		$data['hutang'] = 0;
		if ($d != null) {
			foreach ($d as $row) {
				switch ($row['id_akun']) {
					case 3:
						$data['cash'] = $row['nominal'];break;
					case 5:
						$data['transfer'] = $row['nominal'];break;
					case 46:
						$data['qris'] = $row['nominal'];break;
					case 8:
						$data['hutang'] = $row['nominal'];break;
				}
			}
		}
		
		return $data;
	}

	public static function reverseMonth($month) {	/* MMYYYY */
		// $d = explode('-',$month);
		$m = substr($month,0,2);
		$y = substr($month,-4);
		$t = $y.$m;
		return $t;
	}

	public static function convertMonth($month) {	/* YYYYMM */
		$data = "";
		$m = substr($month,4);
		switch ($m) {
			case "01":
				$data = "Januari";break;
			case "02":
				$data = "Februari";break;
			case "03":
				$data = "Maret";break;
			case "04":
				$data = "April";break;
			case "05":
				$data = "Mei";break;
			case "06":
				$data = "Juni";break;
			case "07":
				$data = "Juli";break;
			case "08":
				$data = "Agustus";break;
			case "09":
				$data = "September";break;
			case "10":
				$data = "Oktober";break;
			case "11":
				$data = "Nopember";break;
			case "12":
				$data = "Desember";break;
		}
		$data = $data." ".substr($month,0,4);
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		// $data = R::load("transaksi",$id);
		// $data["status"] = "na";
		// R::store($data);
		$data = R::load("transaksi",$id);
		R::trash($data);
		TransaksiAkun::deleteByTransaksi($id);
	}
	
	public static function kembali($id) {
		$data = R::load("transaksi",$id);
		$data["status"] = "av";
		R::store($data);
	}
	
	public static function delete($id) {
		$data = R::load("transaksi",$id);
		R::trash($data);
		TransaksiAkun::deleteByTransaksi($id);
	}
	
	public static function deleteByKunjungan($idk) {
		$idt = R::getAll("select id from transaksi where sumber = 'kunjungan' and id_sumber = $idk");
		foreach ($idt as $i) {
			self::delete($i['id']);
			TransaksiAkun::deleteByTransaksi($i['id']);
		}
	}
	
	public static function deleteBySumber($sumber,$ids) {
		$idt = R::getAll("select id from transaksi where sumber = '$sumber' and id_sumber = $ids");
		foreach ($idt as $i) {
			self::remove($i['id']);
		}
	}
	
	public static function generateNomorTransaksi($sumber,$tgl) {
		$t = array();
		$t = explode("-",$tgl);
		$j = "";
		
		if ($sumber == "transaksi" || $sumber == "pemasok") {
			$whereSumber = "(sumber = 'pemasok' OR sumber = 'transaksi')";
		} else {
			$whereSumber = "sumber = '$sumber'";
		}
		// switch ($sumber) {
			// case "staff":
				// $j = "S";break;
			// case "kunjungan":
				// $j = "K";break;
			// case "bendahara":
				// $j = "A";break;
			// case "penjualan":
				// $j = "J";break;
			// case "pemasok":
				// $j = "B";break;
		// }
		$last = R::getCell("SELECT no_transaksi from transaksi where ".$whereSumber." AND FROM_UNIXTIME(tgl_unix,'%Y') = '".$t[2]."' order by no_transaksi desc LIMIT 1");
		if (count($last) == 0) {
			$last = 0;
		}
		$last = $last*1 + 1;
		$nomor = substr("0000".$last,-5);
		// $nomor = $j."/".$t[2]."/".$t[1]."/".$urut;
		
		return $nomor;
	}
	
	public static function regenerateNomorTransaksi() {
		$count = 0;
		$j = "";
		$bln = 0;
		$q = "SELECT id, RIGHT(tgl,4) as thn, MID(tgl,4,2) as bln, LEFT(tgl,2) as hr, sumber FROM transaksi ORDER BY thn, bln, hr";
		$data = R::getAll($q);
		
		foreach ($data as $d) {
			if ($d['bln']*1 != $bln) {
				$count = 1;
				$bln = $d['bln']*1;
			} else {
				$count += 1;
			}
			switch ($d['sumber']) {
				case "admin":
					$j = "A";break;
				case "kunjungan":
					$j = "P";break;
				case "bendahara":
					$j = "B";break;
				case "Penjualan":
					$j = "J";break;
			}
			$urut = substr("0000".$count,-4);
			$no = $j."/".$d['thn']."/".$d['bln']."/".$urut;
			R::exec("UPDATE transaksi SET no_transaksi = '$no' WHERE id = ".$d['id']);
		}
	}
}
?>
