<?php
/** Generated Model Class **/ 

Class Tindakan {    
	private static $columns = "kode,nama,id_kategori,id_poli,d,k,u,m,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$tindakan = R::dispense("m_tindakan");
		if (!self::validate_fields($array)) return false;
		
		$tindakan->import($array,self::$columns);		
		$id = R::store($tindakan);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$tindakan = R::load("m_tindakan",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$tindakan->import($array,self::$columns);		
		
		R::store($tindakan);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from m_tindakan");
	}
		
	public static function getAll($page = 1,$count_per_page = 0) {
		$q = "select * from m_tindakan";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from m_tindakan where id = $id");
		return $data;
	}
	
	public static function getByPoli($idp) {
		$data = R::getAll("select * from m_tindakan where id_poli = $idp ORDER BY SUBSTR(kode,1,1), SUBSTR(kode,4)*1");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("m_tindakan",$id);
		R::trash($data);
	}
}
?>
