<?php
/** Generated Model Class **/ 

Class TahunBuku {
	private static $columns = "tahun,start,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$tahun_buku = R::dispense("tahun_buku");
		if (!self::validate_fields($array)) return false;
		
		$tahun_buku->import($array,self::$columns);		
		$id = R::store($tahun_buku);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$tahun_buku = R::load("tahun_buku",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$tahun_buku->import($array,self::$columns);		
		
		R::store($tahun_buku);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("select count(1) from tahun_buku");
	}
		
	public static function getAll($page = 1,$count_per_page = 0) {
		$q = "select * from tahun_buku ORDER BY tahun";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from tahun_buku where id = $id");
		return $data;
	}
	
	public static function getAktif() {
		$data = R::getRow("select * from tahun_buku where aktif = 'y'");
		return $data;
	}
	
	public static function getStart() {
		$data = R::getCell("select tahun from tahun_buku where start = 'y'");
		return $data;
	}
	
	public static function gantiStatus($tahun,$status) {
		$data = R::getRow("select * from tahun_buku where tahun = $tahun");
		R::exec("update tahun_buku set aktif = $status where tahun = $tahun");
		// return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("tahun_buku",$id);
		R::trash($data);
	}
}
?>
