<?php
/** Generated Model Class **/ 

Class SumberBiaya {    
	private static $columns = "sumber,id_sumber,id_biaya,harga";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$sumber_biaya = R::dispense("sumber_biaya");
		if (!self::validate_fields($array)) return false;
		
		$sumber_biaya->import($array,self::$columns);		
		$id = R::store($sumber_biaya);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$sumber_biaya = R::load("sumber_biaya",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$sumber_biaya->import($array,self::$columns);		
		
		R::store($sumber_biaya);
		return true;
	}
	
	public static function countAll($search = "") {
		
		return R::getCell("SELECT count(1) FROM sumber_biaya");
	}
		
	public static function getAll($page = 1,$count_per_page = 0) {
		$q = "SELECT * FROM sumber_biaya";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll($where)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("SELECT * FROM sumber_biaya WHERE id = $id");
		return $data;
	}
	
	public static function getBySumber($sumber,$ids) {
		$q = "SELECT sb.*, b.nama FROM sumber_biaya sb INNER JOIN m_biaya b ON sb.id_biaya = b.id WHERE sb.sumber = '$sumber' AND sb.id_sumber = $ids";
		$data = R::getAll($q);
		return $data;
	}
	
	public static function cekRegistrasi($ids) {	// cek apakah sudah ada biaya registrasi. Jika belum maka create biaya registrasi
		$count = R::getCell("SELECT COUNT(1) FROM sumber_biaya WHERE sumber = 'kunjungan' AND id_biaya = 1 AND id_sumber = $ids");
		if ($count == 0) {
			$data["id_sumber"] = $ids;
			$data["id_biaya"] = 1;
			$data["harga"] = Biaya::getHarga(1);
			self::create($data);
		}
	}
	
	public static function cekAPD($ids) {
		$idg = Kunjungan::getGolongan($ids);
		$idb = 0;
		if ($idg == 1) {	// tentukan id biaya APD berdasarkan id golongan
			$idb = 2;
		} else if ($idg == 2) {
			$idb = 3;
		} else {
			$idb = 4;
		}
		$count = R::getCell("SELECT COUNT(1) FROM sumber_biaya WHERE sumber = 'kunjungan' AND id_biaya = $idb AND id_sumber = $ids");
		if ($count == 0 && $idg != 1) {
			$data["id_sumber"] = $ids;
			$data["id_biaya"] = $idb;
			$data["harga"] = Biaya::getHarga($idb);
			self::create($data);
		}
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function delete($id) {
		$data = R::load("sumber_biaya",$id);
		R::trash($data);
	}
	
	public static function deleteByKunjungan($ids) {
		$q = "DELETE FROM sumber_biaya WHERE sumber = 'kunjungan' AND id_sumber = $ids";
		R::exec($q);
	}
}
?>
