<?php

Class ReportExcel {
	public static function stockObat($data,$tgl) {	// Penjualan per Obat
		$colTitle = "";

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Apotek Arcade")
									 ->setLastModifiedBy("Admin")
									 ->setTitle("Stock Obat")
									 ->setSubject("Report Excel")
									 ->setDescription("Laporan Stock Obat")
									 ->setKeywords("office openxml php")
									 ->setCategory("Report");

		// Style
		$headStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
					'color' => array('argb' => 'FF000000'),
				),
			),
			'font'=>array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array('argb' => 'FFFFF7C3'),
			)
		);
		$dataStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				)
			)
		);

		// First Sheet
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Stock');
		$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);

		// Title Cell
		$objPHPExcel->getActiveSheet()->setCellValue('A1', "STOCK OBAT tanggal $tgl");

		// Table Header
		$headStartCol = 'A';
		$headStartRow = '3';
		$objPHPExcel->getActiveSheet()->setCellValue('A3', "KODE");
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->setCellValue('B3', "NAMA ITEM");
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('C3', "JUMLAH");
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('D3', "HARGA BELI");
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('E3', "HARGA JUAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('F3', "SATUAN");
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('G3', "PBF TERAKHIR");
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('H3', "EXPIRED DATE");
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
		
		// Data
		$dataStartCol = 'A';
		$dataStartRow = '4';
		$row = 4;
		foreach ($data as $d) {
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $d['kode']);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $d['nama']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $d['jumlah']);
			$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $d['harga_beli']);
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $d['harga_jual']);
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $d['satuan']);
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $d['pbf']);
			$objPHPExcel->getActiveSheet()->setCellValue('H'.$row, $d['exp']);
			$row++;
		}
		
		$dataEndRow = $row;

		// Set Style
		$objPHPExcel->getActiveSheet()->getStyle('D4:D'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('E4:E'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('A4:H'.$dataEndRow)->applyFromArray($dataStyle);
		$objPHPExcel->getActiveSheet()->getStyle('A3:H3')->applyFromArray($headStyle);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Stock Obat '.$tgl.'.xls"');
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	public static function dataPenjualan($data,$awal,$akhir,$total = 0) {	// Penjualan per Obat
		$colTitle = "";

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Apotek Arcade")
									 ->setLastModifiedBy("Admin")
									 ->setTitle("Penjualan Obat")
									 ->setSubject("Report Excel")
									 ->setDescription("Laporan Penjualan Obat")
									 ->setKeywords("office openxml php")
									 ->setCategory("Report");

		// Style
		$headStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
					'color' => array('argb' => 'FF000000'),
				),
			),
			'font'=>array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array('argb' => 'FFFFF7C3'),
			)
		);
		$dataStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				)
			)
		);

		// First Sheet
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Penjualan');
		$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);

		// Title Cell
		$objPHPExcel->getActiveSheet()->setCellValue('A1', "PENJUALAN OBAT dari $awal sampai $akhir");

		// Table Header
		$headStartCol = 'A';
		$headStartRow = '3';
		$objPHPExcel->getActiveSheet()->setCellValue('A3', "TANGGAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->setCellValue('B3', "FAKTUR");
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('C3', "OBAT");
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(50);
		$objPHPExcel->getActiveSheet()->setCellValue('D3', "HARGA");
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('E3', "JUMLAH");
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('F3', "DISKON");
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('G3', "TOTAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
		
		// Data
		$dataStartCol = 'A';
		$dataStartRow = '4';
		$row = 4;
		foreach ($data as $d) {
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $d['tgl']);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, " ".$d['no_transaksi']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $d['nama']);
			$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $d['harga']);
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $d['jumlah']);
			if ($d['tipe_diskon'] == 1) {
				$diskon = $d['diskon']."%";
			} else {
				$diskon = $d['diskon'];
			}
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $diskon);
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $d['total']);
			$row++;
		}
		$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, "TOTAL");
		$objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':F'.$row);
		$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $total);
		
		$dataEndRow = $row;

		// Set Style
		$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('D4:D'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('F4:G'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('F4:F'.$dataEndRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		$objPHPExcel->getActiveSheet()->getStyle('A4:G'.$dataEndRow)->applyFromArray($dataStyle);
		$objPHPExcel->getActiveSheet()->getStyle('A3:G3')->applyFromArray($headStyle);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Penjualan Obat '.$awal.'-'.$akhir.'.xls"');
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	public static function penjualanHarian($data,$date) {		/* Penjualan harian */
		$colTitle = "";

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Apotek Arcade")
									 ->setLastModifiedBy("Admin")
									 ->setTitle("Penjualan Harian")
									 ->setSubject("Report Excel")
									 ->setDescription("Laporan Penjualan Harian")
									 ->setKeywords("office openxml php")
									 ->setCategory("Report");

		// Style
		$headStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
					'color' => array('argb' => 'FF000000'),
				),
			),
			'font'=>array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array('argb' => 'FFFFF7C3'),
			)
		);
		$dataStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				)
			),
			'alignment' => array(
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_TOP
			)
		);

		// First Sheet
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Penjualan');
		$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);

		// Title Cell
		$objPHPExcel->getActiveSheet()->setCellValue('A1', "PENJUALAN HARIAN tanggal $date");

		// Table Header
		$headStartCol = 'A';
		$headStartRow = '3';
		$objPHPExcel->getActiveSheet()->setCellValue('A3', "TANGGAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->setCellValue('B3', "JAM");
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('C3', "FAKTUR");
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('D3', "OBAT");
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(60);
		$objPHPExcel->getActiveSheet()->setCellValue('E3', "DISKON");
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('F3', "BAYAR");
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('G3', "TOTAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
		
		// Data
		$dataStartCol = 'A';
		$dataStartRow = '4';
		$row = 4;
		$total = 0;
		foreach ($data as $d) {
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $d['tgl']);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $d['jam']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, " ".$d['no_transaksi']);
			if ($d['tipe_diskon'] == 1) {
				$diskon = $d['diskon']."%";
			} else {
				$diskon = $d['diskon'];
			}
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $diskon);
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $d['jenisPembayaran']);
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $d['total']);
			foreach ($d['obat'] as $o) {
				if ($o['diskon'] > 0) {
					if ($o['tipe_diskon'] == 1) {
						$txtDiskon = " - disc. ".$o['diskon']."%";
					} else {
						$txtDiskon = " - disc. ".$o['diskon'];
					}
				} else {
					$txtDiskon = "";
				}
				$txt = $o['nama']." [".$o['jumlah']."x".$o['harga'].$txtDiskon."]";
				$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $txt);
				$row++;
			}
			$count = count($d['obat']);
			$mergeAwal = $row-$count;
			$mergeAkhir = $row-1;
			$objPHPExcel->getActiveSheet()->mergeCells('A'.$mergeAwal.':A'.$mergeAkhir);
			$objPHPExcel->getActiveSheet()->mergeCells('B'.$mergeAwal.':B'.$mergeAkhir);
			$objPHPExcel->getActiveSheet()->mergeCells('C'.$mergeAwal.':C'.$mergeAkhir);
			$objPHPExcel->getActiveSheet()->mergeCells('E'.$mergeAwal.':E'.$mergeAkhir);
			$objPHPExcel->getActiveSheet()->mergeCells('F'.$mergeAwal.':F'.$mergeAkhir);
			$objPHPExcel->getActiveSheet()->mergeCells('G'.$mergeAwal.':G'.$mergeAkhir);
			$total += $d['total'];
		}
		$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, "TOTAL PENJUALAN");
		$objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':F'.$row);
		$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $total);
		
		$dataEndRow = $row;

		// Set Style
		$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('E4:E'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('E4:E'.$dataEndRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		$objPHPExcel->getActiveSheet()->getStyle('G4:G'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('G4:G'.$dataEndRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		$objPHPExcel->getActiveSheet()->getStyle('A4:G'.$dataEndRow)->applyFromArray($dataStyle);
		$objPHPExcel->getActiveSheet()->getStyle('A3:G3')->applyFromArray($headStyle);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Penjualan Harian '.$date.'.xls"');
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	public static function obatMasuk($data,$date) {
		$colTitle = "";

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Apotek Arcade")
									 ->setLastModifiedBy("Admin")
									 ->setTitle("Obat Masuk")
									 ->setSubject("Report Excel")
									 ->setDescription("List Obat Masuk")
									 ->setKeywords("office openxml php")
									 ->setCategory("Report");

		// Style
		$headStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
					'color' => array('argb' => 'FF000000'),
				),
			),
			'font'=>array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array('argb' => 'FFFFF7C3'),
			)
		);
		$dataStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				)
			),
			'alignment' => array(
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_TOP
			)
		);

		// First Sheet
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Masuk');
		$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);

		// Title Cell
		$objPHPExcel->getActiveSheet()->setCellValue('A1', "OBAT MASUK");

		// Table Header
		$headStartCol = 'A';
		$headStartRow = '3';
		$objPHPExcel->getActiveSheet()->setCellValue('A3', "TANGGAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->setCellValue('B3', "NAMA OBAT");
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('C3', "PEMASOK");
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('D3', "JUMLAH");
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('E3', "SATUAN");
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('F3', "BELI");
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('G3', "JUAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('H3', "ED");
		$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(12);
		
		// Data
		$dataStartCol = 'A';
		$dataStartRow = '4';
		$row = 4;
		$total = 0;
		foreach ($data as $d) {
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $d['tgl']);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $d['obat'][0]['nama']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $d['pemasok']);
			$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $d['jumlah']);
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $d['obat'][0]['kecil']);
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $d['harga_beli']);
			$objPHPExcel->getActiveSheet()->setCellValue('G'.$row, $d['harga_jual']);
			$objPHPExcel->getActiveSheet()->setCellValue('H'.$row, $d['exp']);
			$row++;
		}
		
		$dataEndRow = $row-1;

		// Set Style
		$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('F4:G'.$dataEndRow)->getNumberFormat()->setFormatCode('#,##0');
		$objPHPExcel->getActiveSheet()->getStyle('F4:G'.$dataEndRow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
		$objPHPExcel->getActiveSheet()->getStyle('A4:H'.$dataEndRow)->applyFromArray($dataStyle);
		$objPHPExcel->getActiveSheet()->getStyle('A3:H3')->applyFromArray($headStyle);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Obat Masuk '.$date.'.xls"');
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
	
	public static function obatKeluar($data,$date) {
		$colTitle = "";

		$objPHPExcel = new PHPExcel();
		$objPHPExcel->getProperties()->setCreator("Apotek Arcade")
									 ->setLastModifiedBy("Admin")
									 ->setTitle("Obat Keluar")
									 ->setSubject("Report Excel")
									 ->setDescription("Laporan Obat Keluar")
									 ->setKeywords("office openxml php")
									 ->setCategory("Report");

		// Style
		$headStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_MEDIUM,
					'color' => array('argb' => 'FF000000'),
				),
			),
			'font'=>array(
				'bold' => true
			),
			'alignment' => array(
				'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER
			),
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'startcolor' => array('argb' => 'FFFFF7C3'),
			)
		);
		$dataStyle = array(
			'borders' => array(
				'allborders' => array(
					'style' => PHPExcel_Style_Border::BORDER_THIN,
					'color' => array('argb' => 'FF000000'),
				)
			),
			'alignment' => array(
				'vertical' => PHPExcel_Style_Alignment::VERTICAL_TOP
			)
		);

		// First Sheet
		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->setTitle('Masuk');
		$objPHPExcel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_PORTRAIT);

		// Title Cell
		$objPHPExcel->getActiveSheet()->setCellValue('A1', "OBAT KELUAR");

		// Table Header
		$headStartCol = 'A';
		$headStartRow = '3';
		$objPHPExcel->getActiveSheet()->setCellValue('A3', "TANGGAL");
		$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(12);
		$objPHPExcel->getActiveSheet()->setCellValue('B3', "NAMA OBAT");
		$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('C3', "ALASAN");
		$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
		$objPHPExcel->getActiveSheet()->setCellValue('D3', "JUMLAH");
		$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('E3', "SATUAN");
		$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(10);
		$objPHPExcel->getActiveSheet()->setCellValue('F3', "KETERANGAN");
		$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(15);
		
		// Data
		$dataStartCol = 'A';
		$dataStartRow = '4';
		$row = 4;
		$total = 0;
		foreach ($data as $d) {
			$objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $d['tgl']);
			$objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $d['nama']);
			$objPHPExcel->getActiveSheet()->setCellValue('C'.$row, $d['sumber']);
			$objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $d['jumlah']);
			$objPHPExcel->getActiveSheet()->setCellValue('E'.$row, $d['kecil']);
			$objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $d['keterangan']);
			$row++;
		}
		
		$dataEndRow = $row-1;

		// Set Style
		$objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setBold(true);
		$objPHPExcel->getActiveSheet()->getStyle('A4:F'.$dataEndRow)->applyFromArray($dataStyle);
		$objPHPExcel->getActiveSheet()->getStyle('A3:F3')->applyFromArray($headStyle);

		header('Content-Type: application/vnd.ms-excel');
		header('Content-Disposition: attachment;filename="Obat Keluar '.$date.'.xls"');
		header('Cache-Control: max-age=0');

		$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
		$objWriter->save('php://output');
	}
}