<?php
/** Generated Model Class **/ 

Class Profil {    
	private static $columns = "nik,nama,alamat,tgl_lahir,sex,tlp,status";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,nama,Nama belum terisi.";
		$rules[] = "required,status,Status belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$profil = R::dispense("m_profil");
		
		if (!self::validate_fields($array)) return false;
		
		$profil->import($array,self::$columns);
		$id = R::store($profil);
		return $id;
	}
	
	public static function update($id,$array) {
		$profil = R::load("m_profil",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$profil->import($array,self::$columns);		
		
		$id = R::store($profil);
		R::store($profil);
		return true;
	}	
	
	public static function countAll() {
		return R::getCell("select count(1) from m_profil");
	}
	
	public static function getByTelepon($telepon) {
		return R::getRow("select * from m_profil where tlp like '$telepon'");
	}
	
	public static function getAll($page = 1,$count_per_page = 0) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select * from m_profil order by id limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
		}
		return $data;
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll()/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from m_profil where id = $id");
		return $data;
	}
	
	public static function getNama($id) {
		$data = R::getCell("select nama from m_profil where id = $id");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("user",$id);
		$data["status"] = "keluar";
		R::store($data);
		// R::trash($data);
	}
}
?>
