<?php
/** Generated Model Class **/ 

Class Pasien {    
	private static $columns = "nama,namakel,alamat,no_nik,tempat_lahir,tgl_lahir,sex,tlp,id_golongan,kelompok,no_rekmed";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	private static function validate_fields($array) {
		$rules = array();
		$rules[] = "required,nama,Nama belum terisi.";
		$rules[] = "required,no_nik,No. KK belum terisi.";
		$rules[] = "required,tgl_lahir,Tangga Lahir belum terisi.";
		$errors = validateFields($array, $rules);
		if (!empty($errors))
		{  
			$error_msg = "<ul>";
			foreach ($errors as $e) { $error_msg .= "<li>{$e}</li>"; }
			$error_msg .= "</ul>";
			Slim::flash('error',$error_msg);
			return false;
		} else { return true; }
	}
	
	public static function create($array) {			
		$pasien = R::dispense("m_pasien");
		
		if (!self::validate_fields($array)) return false;
		
		$pasien->import($array,self::$columns);
		$id = R::store($pasien);
		return $id;
	}
	
	public static function update($id,$array) {
		$pasien = R::load("m_pasien",$id);
		
		if (!self::validate_fields($array)) return false;
		
		$pasien->import($array,self::$columns);		
		
		$id = R::store($pasien);
		R::store($pasien);
		return true;
	}	
	
	public static function countAll() {
		return R::getCell("select count(1) from m_pasien");
	}
	
	public static function countAllKriteria($kriteria = "") {
		return R::getCell("select count(1) from m_pasien where no_rekmed like '%".$kriteria."%' or nama like '%".$kriteria."%' or no_nik like '%".$kriteria."%'");
	}
	
	public static function getByTelepon($telepon) {
		return R::getRow("select * from m_pasien where tlp like '$telepon'");
	}
	
	public static function getAll($page = 1,$count_per_page = 0) {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select p.*, b.nama as golongan from m_pasien p inner join m_golongan b on p.id_golongan = b.id order by no_rekmed desc limit $start_record,$count_per_page";
		$data = R::getAll($q);
		
		foreach ($data as $key=>$d) {
		}
		return $data;
	}
	
	public static function getByKriteria($page = 1,$count_per_page = 0,$kriteria = "") {
		$count_per_page = ($count_per_page == 0 ? 30 : $count_per_page);
		$start_record = $count_per_page * ($page -1);
		$q = "select p.*, b.nama as golongan from m_pasien p inner join m_golongan b on p.id_golongan = b.id 
				where p.no_rekmed like '%".$kriteria."%' or p.nama like '%".$kriteria."%' or p.no_nik like '%".$kriteria."%' 
				order by id desc limit $start_record,$count_per_page";
		$data = R::getAll($q); 
		return $data;
	}
	
	public static function generatePageKriteria($current_page,$count_per_page,$base_url,$kriteria = "") {
		$total_page = ceil(self::countAllKriteria($kriteria)/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			if ($kriteria == "") {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
			} else {
				$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?find=".$kriteria."&p=$i");
			}
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function generatePage($current_page,$count_per_page,$base_url) {
		$total_page = ceil(self::countAll()/$count_per_page);
		for ($i = 1;$i <= $total_page;$i++) {
			$active = ($i == $current_page ? "yes" : "no");
			$page[] = array("number"=>$i,"active"=>$active,"link"=>$base_url."?p=$i");
		}
		return  (isset($page) ? $page : array());
	}
	
	public static function get($id) {
		$data = R::getRow("select * from m_pasien where id = $id");
		return $data;
	}
	
	public static function getById($id) {
		$data = R::getRow("select p.*, b.nama as golongan from m_pasien p inner join m_golongan b on p.id_golongan = b.id where p.id = $id");
		return $data;
	}
	
	public static function getByRekMed($id) {
		$data = R::getRow("select p.*, b.nama as golongan from m_pasien p inner join m_golongan b on p.id_golongan = b.id where p.no_rekmed like '$id'");
		return $data;
	}
	
	public static function getNewRm() {
		$q = "select no_rekmed from m_pasien order by no_rekmed desc";
		
		$rm = R::getCell($q);
		$newRM = $rm + 1;
		$addzero = 6 - strlen($newRM);
		for ($i = 1;$i <= $addzero;$i++) {
			$newRM = "0".$newRM;
		}
		return $newRM;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("m_pasien",$id);
		R::trash($data);
	}
}
?>
