<?php
/** Generated Model Class **/ 

Class Akun {    
	private static $columns = "nama,kode,id_jenis,subkode,normal,posisi,awal,bendahara,admin,aktif";
	private static $errors;
	
	private static function generate_date($field_name,$array) {
		if (isset($array[$field_name.'_date']) && isset($array[$field_name.'_month']) && isset($array[$field_name.'_date']))
		$array[$field_name.''] = mktime(0, 0, 0, $array[$field_name.'_month'], $array[$field_name.'_date'], $array[$field_name.'_year']);
		
		return $array;
	}
	
	public static function create($array) {
		$akun = R::dispense("akun");
		
		$akun->import($array,self::$columns);
		$id = R::store($akun);
		
		return $id;
	}
	
	public static function update($id,$array) {
		$akun = R::load("akun",$id);
		
		$akun->import($array,self::$columns);		
		
		R::store($akun);
		return true;
	}
	
	public static function countAll($active = "") {
	
		if ($active == "all") {
			$q = "select count(1) from akun";
		} else {
			$q = "select count(1) from akun where aktif = 'y'";
		}
		
		$data = R::getCell($q);
		return $data;
	}
	
	public static function getAll($active = "") {

		if ($active == "all") {
			$q = "select * from akun";
		} else {
			$q = "select * from akun where aktif = 'y'";
		}
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getAllByBidang($bidang,$active = "") {	// ambil akun termasuk akun parent

		if ($active == "all") {
			$q = "select id, nama, $bidang as val, aktif from akun order by nama";
		} else {
			$q = "select id, nama, $bidang as val, aktif from akun where aktif = 'y' order by nama";
		}
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByName($akun = "") {
		$q = "select * from akun where nama like '%".$akun."%'";
		
		$data = R::getRow($q);
		return $data;
	}
	
	public static function getByJenis($id_jenis = 0) {
		$q = "select * from akun where id_jenis = $id_jenis order by kode, subkode";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function get($id,$bidang = "") {
		if ($bidang == "") {
			$q = "select * from akun where id = $id";
		} else {
			$q = "select id, nama, $bidang as val, aktif from akun where id = $id";
		}
		$data = R::getRow($q);
		return $data;
	}
	
	public static function getByBidang($bidang,$active = "") {	// ambil akun tanpa akun parent
		$a = $active ? "and aktif = 'y'" : "";
		$q = "select id, nama, kode, subkode, $bidang as jenis, id_jenis from akun where $bidang <> 'n' $a order by kode,subkode";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getByPosisi($posisi) {
		$q = "select * from akun where posisi = '$posisi' order by kode,subkode";
		
		$data = R::getAll($q);
		return $data;
	}
	
	public static function getSaldo($id) {
		$data = R::getRow("select awal, normal from akun where id = $id");
		$data['debit'] = Transaksi::getSaldo($id,"debit");
		$data['kredit'] = Transaksi::getSaldo($id,"kredit");
		return $data;
	}
	
	public static function getSaldoAwal($id = 0,$posisi = "") {		
		if ($id == 0) {
			$where = ($posisi != "" ? "and posisi = '$posisi' " : "");
			$data = R::getAll("select id, nama, kode, subkode, id_jenis, awal from akun where aktif = 'y' and bendahara <> 'n' $where order by kode, subkode");
		} else {
			$data = R::getCell("select awal from akun where id = $id");
		}
		
		return $data;
	}
	
	public static function getNama($id) {
		$data = R::getCell("select nama from akun where id = $id");
		return $data;
	}
	
	public static function getNormal($id) {
		$data = R::getCell("select normal from akun where id = $id");
		return $data;
	}
	
	public static function getColumns() {
		return explode(",",self::$columns);
	}

	public static function remove($id) {
		$data = R::load("akun",$id);
		$data["aktif"] = "t";
		R::store($data);
		// R::trash($data);
	}
	
	public static function delete($id) {
		$data = R::load("akun",$id);
		R::trash($data);
	}
}
?>
