<?php 

/**
 * Super Admin Authentication
 */
 
Slim::get('/admin/(:model)(/:action)(/:id)',function($model= 0,$action = 0,$id = 0) {
	User::check_login('management');
	Slim::pass();
});

/**
 * Super Admin Home
 */
 
Slim::get('/admin/report',function() {
	User::check_login('management');

	Slim::render("admin/report/home.html");
})->name('admin_home');

/**
 * Report Kunjungan
 */

Slim::get('/admin/report/kunjungan',function() {
	User::check_login('management');
	// User::check_permit('report','kunjungan');
	
	$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
	$count_per_page = 30;

	$find = (isset($_GET['find']) ? $_GET['find'] : "");
	$data = Report::kunjungan($current_page,$count_per_page,$find);
	$page = Report::generatePage($current_page,$count_per_page,Customer::countAll($find),Slim::urlfor("admin_report_kunjungan"),$find);

	Slim::render("admin/report/kunjungan.html",array(
		"data"=>$data,
		"page"=>$page,
		"find"=>$find
	));
})->name('admin_report_kunjungan');

/**
 * Report Gaji Dokter
 */

Slim::get('/admin/report/gajidokter',function() {
	User::check_login('management');
	// User::check_permit('report','gajidokter');
	
	$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
	$count_per_page = 30;

	$find = (isset($_GET['find']) ? $_GET['find'] : "");
	$data = Report::customer($current_page,$count_per_page,$find);
	$page = Report::generatePage($current_page,$count_per_page,Customer::countAll($find),Slim::urlfor("admin_report_gajidokter"),$find);

	Slim::render("admin/report/gaji_dokter.html",array(
		"data"=>$data,
		"page"=>$page,
		"find"=>$find
	));
})->name('admin_report_gajidokter');

/**
 * Report Tindakan
 */

Slim::get('/admin/report/tindakan',function() {
	User::check_login('management');
	// User::check_permit('report','tindakan');
	
	$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
	$count_per_page = 30;

	$find = (isset($_GET['find']) ? $_GET['find'] : "");
	$data = Report::customer($current_page,$count_per_page,$find);
	$page = Report::generatePage($current_page,$count_per_page,Customer::countAll($find),Slim::urlfor("admin_report_tindakan"),$find);

	Slim::render("admin/report/tindakan.html",array(
		"data"=>$data,
		"page"=>$page,
		"find"=>$find
	));
})->name('admin_report_tindakan');

/**
 * Report Bagi Hasil
 */

Slim::get('/admin/report/bagihasil',function() {
	User::check_login('management');
	// User::check_permit('report','bagihasil');
	
	$current_page = (isset($_GET['p']) ? $_GET['p'] : 1);
	$count_per_page = 30;

	$find = (isset($_GET['find']) ? $_GET['find'] : "");
	$data = Report::customer($current_page,$count_per_page,$find);
	$page = Report::generatePage($current_page,$count_per_page,Customer::countAll($find),Slim::urlfor("admin_report_bagihasil"),$find);

	Slim::render("admin/report/bagi_hasil.html",array(
		"data"=>$data,
		"page"=>$page,
		"find"=>$find
	));
})->name('admin_report_bagihasil');

?>