<?php

/**
 * Kas
 */

Slim::get('/registrasi/keuangan/kas',function() {
	User::check_login('registrasi');

	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$utime = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
		$time = Rumus::addZeroDate($_GET['tgl']);
	} else {
		$utime = time();
		$time = date("d-m-Y",time());
	}

	$data = Transaksi::getByDateAkun($time,3);
	$akhir = Akun::getSaldo(3);
	$kas['akhir'] = $akhir['awal'] + $akhir['debit'] - $akhir['kredit'];
	
	$kas['debit'] = 0;
	$kas['kredit'] = 0;
	$kas['saldo'] = 0;
	if ($data != null) {
		foreach ($data as $k=>$d) {
			$kas['debit'] += $data[$k]['debit'];
			$kas['kredit'] += $data[$k]['kredit'];
			$data[$k]['saldo'] = $kas['saldo'] + $data[$k]['debit'] - $data[$k]['kredit'];
		}
	}
	$kas['saldo'] = $kas['debit'] - $kas['kredit'];

	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_kas_".$_GET['tgl'].".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("registrasi/keuangan/kasxls.html",array(
			"data"=>$data,
			"kas"=>$kas,
			"tgl"=>$time
		));
	} else {
		Slim::render("registrasi/keuangan/kas.html",array(
			"data"=>$data,
			"kas"=>$kas,
			"tgl"=>date("d-M-Y",$utime),
			"tgl_js"=>date("F d,Y",$utime),
			"tgl_get"=>date("d-m-Y",$utime)
		));
	}
})->name('registrasi_keuangan_kas');

/**
 * New Kas
 */

Slim::get('/registrasi/keuangan/kasnew/',function() {
	User::check_login('registrasi');
	
	$akun = Akun::getByBidang("admin");
	Slim::render("registrasi/keuangan/kasnew.html",array(
		"akun"=>$akun,
		"tgl"=>date("d-m-Y",time()),
		"tgl_js"=>date("F d,Y",time())
	));
})->name('registrasi_keuangan_new');

Slim::post('/registrasi/keuangan/kasnew/',function() {
	User::check_login('registrasi');
	
	$data['tgl'] = $_POST['tgl'];
	$data['no_transaksi'] = Transaksi::generateNomorTransaksi("admin",$_POST['tgl']);
	$data['uraian'] = $_POST['uraian'];
	$data['id_user'] = $_SESSION['user']['id'];
	
	$idt = Transaksi::create($data);
	if (!is_null($idt)) {
		
		if ($_POST['jenis'] == "m") {
			TransaksiAkun::create(array(	// create transaksi debit
				"id_transaksi"=>$idt,
				"id_akun"=>3,
				"debit"=>Rumus::idrToInt($_POST['nominal']),
				"kredit"=>0
			));
			TransaksiAkun::create(array(	// create transaksi kredit
				"id_transaksi"=>$idt,
				"id_akun"=>$_POST['akunm'],
				"debit"=>0,
				"kredit"=>Rumus::idrToInt($_POST['nominal'])
			));
		} else {
			TransaksiAkun::create(array(	// create transaksi debit
				"id_transaksi"=>$idt,
				"id_akun"=>$_POST['akunk'],
				"debit"=>Rumus::idrToInt($_POST['nominal']),
				"kredit"=>0
			));
			TransaksiAkun::create(array(	// create transaksi kredit
				"id_transaksi"=>$idt,
				"id_akun"=>3,
				"debit"=>0,
				"kredit"=>Rumus::idrToInt($_POST['nominal'])
			));
		}
		redir_by_id("registrasi_keuangan_kas",array(),'?tgl='.$_POST['tgl']);
	} else {
		Slim::render('registrasi/keuangan/kasnew.html',array(
			"data"=>$_POST
		));
	}
});

/**
 * Edit Kas
 */
 
Slim::get('/registrasi/keuangan/kasedit(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	$akun = Akun::getByBidang("admin");
	$data = Transaksi::get($id);
	$transaksiAkun = TransaksiAkun::getByTransaksi($id);
	$data['jenis'] = "m";
	$data['nominal'] = 0;
	
	foreach ($transaksiAkun as $ta) {
		if ($ta['debit'] > 0) {
			$data['id_akun_debit'] = $ta['id_akun'];
		} else {
			$data['id_akun_kredit'] = $ta['id_akun'];
		}
		$data['nominal'] = $ta['debit'] + $ta['kredit'];
	}
	if ($data['id_akun_debit'] == 3) {
		$data['jenis'] = "m";
	} else {
		$data['jenis'] = "k";
	}
	
	Slim::render("registrasi/keuangan/kasedit.html",array(
		"data"=>$data,
		"akun"=>$akun,
		"tgl"=>$data['tgl'],
		"tgl_js"=>date("F d,Y",time())
	));
})->name('registrasi_keuangan_edit');

Slim::post('/registrasi/keuangan/kasedit(/:id)',function($id = 0) {
	User::check_login('registrasi');
	
	if ($id == 0) redir_by_id("registrasi_keuangan_kas");
	$data = Transaksi::get($id);
	$data['tgl'] = $_POST['tgl'];
	$data['uraian'] = $_POST['uraian'];
	$data['id_user'] = $_SESSION['user']['id'];
	if ($_POST['jenis'] == "m") {
		$akunKas['debit'] = Rumus::idrToInt($_POST['nominal']);
		$akunKas['kredit'] = 0;
		$akunLain['debit'] = 0;
		$akunLain['kredit'] = Rumus::idrToInt($_POST['nominal']);
		$akunLain['id'] = $_POST['akunm'];
	} else {
		$akunKas['debit'] = 0;
		$akunKas['kredit'] = Rumus::idrToInt($_POST['nominal']);
		$akunLain['debit'] = Rumus::idrToInt($_POST['nominal']);
		$akunLain['kredit'] = 0;
		$akunLain['id'] = $_POST['akunk'];
	}
	
	if (Transaksi::update($id,$data)) {
		$ta = TransaksiAkun::getByTransaksi($id);
		TransaksiAkun::update($ta[0]['id'],array(	// create transaksi debit
			"id_transaksi"=>$id,
			"id_akun"=>3,
			"debit"=>$akunKas['debit'],
			"kredit"=>$akunKas['kredit']
		));
		TransaksiAkun::update($ta[1]['id'],array(	// create transaksi kredit
			"id_transaksi"=>$id,
			"id_akun"=>$akunLain['id'],
			"debit"=>$akunLain['debit'],
			"kredit"=>$akunLain['kredit']
		));
		
		redir_by_id("registrasi_keuangan_kas",array(),'?tgl='.$_POST['tgl']);
	} else {
		$akun = Akun::getByBidang("admin");
		Slim::render('registrasi/keuangan/kasedit.html',array(
			"data"=>$_POST,
			"akun"=>$akun
		));
	}
});

/**
 * Delete Kas
 */

Slim::get('/registrasi/keuangan/kasdel(/:id)',function($id = 0) {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if ($id == 0) redir_by_id("registrasi_keuangan_kas");

	Transaksi::delete($id);
	redir_by_id("registrasi_keuangan_kas");
})->name('registrasi_keuangan_del');

/**
 * Laporan Keuangan
 */

Slim::get('/registrasi/keuangan/laporan',function() {
	User::check_login('registrasi');
	// User::check_permit('edit','pasien');

	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Report::kunjunganHarian(date("d-m-Y",$time));
	foreach ($data as $k=>$d) {
		$data[$k]['span'] = count($d['tindakan']) + count($d['obat']) + count($d['biaya']) + 1;
		$count = 0;
		foreach ($d['tindakan'] as $t) {
			$data[$k]['gabungan'][$count] = $t;
			$count++;
		}
		foreach ($d['obat'] as $o) {
			$data[$k]['gabungan'][$count] = $o;
			$count++;
		}
		foreach ($d['biaya'] as $b) {
			$data[$k]['gabungan'][$count] = $b;
			$count++;
		}
	}
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=LAPORAN_kunjungan_".$_GET['tgl'].".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("registrasi/keuangan/laporanxls.html",array(
			"data"=>$data,
			"tgl"=>date("d-M-Y",$time)
		));
	} else {
		Slim::render('registrasi/keuangan/laporan.html',array(
			"data"=>$data,
			"tgl"=>date("d-M-Y",$time),
			"tgl_js"=>date('F d,Y',$time),
			"tgl_get"=>date("d-m-Y",$time)
		));
	}
})->name('registrasi_keuangan_laporan');
?>