<?php

/**
 * Home 
 */

Slim::get('/perawat/home',function() {
	User::check_login('perawat');
	
	redir_by_id("perawat_kunjungan");
})->name('perawat_home');

/**
 * Kunjungan
 */

Slim::get('/perawat/kunjungan',function() {
	User::check_login('perawat');
	
	if (isset($_GET['tgl'])) {
		$d = explode('-',$_GET['tgl']);
		$time = mktime(0, 0, 0, $d[1], $d[0], $d[2]);
	} else { $time = time(); }
	
	$data = Kunjungan::getByDate(date("d-m-Y",$time),$_SESSION['user']['id_poli']);
	foreach ($data as $key=>$d) {
		$data[$key]['usia'] = intval(date('Y', time() - strtotime($d["tgl_lahir"]))) - 1970;
		$data[$key]['tgl'] = date("d M Y",$d['tgl']);
		$data[$key]['jam'] = date("H:i",$d['tgl']);
	}
	Slim::render('perawat/kunjungan.html',array(
		'data' => $data,
		"tgl"=>date("d-M-Y",$time),
		"tgl_js"=>date('F d,Y',$time),
		"tgl_get"=>date("d-m-Y",$time),
		'current' => getdate()
	));
})->name('perawat_kunjungan');

/**
 * Laporan Harian
 */

Slim::get('/perawat/laporan',function() {
	User::check_login('perawat');
	
	if (isset($_GET['monthly_month'])) {
		$bln = Rumus::addZero($_GET['monthly_month']);
		$thn = $_GET['monthly_year'];
		$time = $bln."-".$thn;
	} else {
		$time = date("m-Y",time());
		$bln = date("m",time());
		$thn = date("Y",time());
	}
	
	$idpoli = 0;
	if (isset($_GET['poli'])) {
		$idpoli = $_GET['poli'];
	}
	
	if ($idpoli > 0) {
		$poli = Poli::get($idpoli);
	} else {
		$poli['id'] = 0;
		$poli['nama'] = "Semua";
	}
	
	$polis = Poli::getAll();
	$data = Report::laporanHarian($time,$idpoli);
	
	if (isset($_GET['xls'])) {
		header("Content-type: application/vnd.ms-excel");
		header("Content-disposition: attachment; filename=Laporan_Harian_Poli_".$poli['nama']."_".$time.".xls"); // filename terserah anda
		header("Pragma: no-cache");
		header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
		header("Expires: 0");
		Slim::render("perawat/laporanxls.html",array(
			"data"=>$data
		));
	} else {
		Slim::render('perawat/laporan.html',array(
			"data"=>$data,
			"tgl"=>$time,
			"bln"=>$bln*1,
			"thn"=>$thn,
			"poli"=>$poli,
			"polis"=>$polis
		));
	}
})->name('perawat_laporan');

/**
 * Periksa
 */

Slim::get('/perawat/periksa',function() {
	User::check_login('perawat');
	
	if (isset($_GET['idk'])) {
		$data = Kunjungan::get($_GET['idk']);
		$histori = Kunjungan::getListHistori($data['id_pasien']);
		$pasien = Pasien::getById($data['id_pasien']);
		$poli = Poli::get($data['id_poli']);
		$dokter = UserPoli::getByPoli($data['id_poli']);
		// $obat = Obat::getByGol($data['id_golongan']);
		$obat = Obat::getAll();
		$tindakan = Tindakan::getByPoli($data['id_poli']);
		$data['golongan'] = Golongan::getNama($data['id_golongan']);
		
		if ($data['id_ttv'] != null) {
			$ttv = Ttv::get($data['id_ttv']);
		} else {
			$ttv = null;
		}
		
		$tindakank = KunjunganTindakan::getByKunjungan($_GET['idk']);
		$obatk = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
		
		foreach ($tindakan as $key=>$d) {
			switch ($data['id_golongan']) {
				case 1:
					$tindakan[$key]['harga_jual'] = $d['d'];
					break;
				case 2:
					$tindakan[$key]['harga_jual'] = $d['k'];
					break;
				case 3:
					$tindakan[$key]['harga_jual'] = $d['u'];
					break;
				case 4:
					$tindakan[$key]['harga_jual'] = $d['m'];
					break;
			}
		}
		
		foreach ($obat as $key=>$d) {
			if ($d['status'] == 's' and $data["id_golongan"] == 1) {
				$obat[$key]['harga_jual'] = 0;		// gratiskan obat subsidi
			}
		}
		$pasien['usia'] = intval(date('Y', time() - strtotime($pasien["tgl_lahir"]))) - 1970;
		$data['tanggal'] = date("d M Y",$data['tgl']);
		$data['jam'] = date("H:i",$data['tgl']);
		
		Slim::render('perawat/periksa.html',array(
			'data' => $data,
			'pasien' => $pasien,
			'poli' => $poli,
			'dokter' => $dokter,
			'obat' => $obat,
			'tindakan' => $tindakan,
			'obatk' => $obatk,
			'tindakank' => $tindakank,
			'histori' => $histori,
			'ttv' => $ttv
		));
	} else {
		redir_by_id('perawat_kunjungan');
	}
})->name('perawat_periksa');

Slim::post('/perawat/periksa',function() {
	User::check_login('perawat');

	$k = Kunjungan::get($_GET['idk']);
	$k['keluhan'] = $_POST['keluhan'];
	$k['diagnosis'] = $_POST['diagnosis'];
	$k['keterangan'] = $_POST['keterangan'];
	$k['id_dokter'] = $_POST['dokter'];
	$k['id_perawat'] = $_SESSION['user']['id'];
	$k['status'] = "bayar";
	
	if ($k['id_ttv'] == null) {
		$k['id_ttv'] = Ttv::create(array(
				"suhu"=>$_POST['suhu'],
				"denyut"=>$_POST['denyut'],
				"tekanan_darah"=>$_POST['tekanan_darah'],
				"pernapasan"=>$_POST['pernapasan'],
				"berat"=>$_POST['berat'],
				"tinggi"=>$_POST['tinggi']
			));
	} else {
		Ttv::update($k['id_ttv'],array(
				"suhu"=>$_POST['suhu'],
				"denyut"=>$_POST['denyut'],
				"tekanan_darah"=>$_POST['tekanan_darah'],
				"pernapasan"=>$_POST['pernapasan'],
				"berat"=>$_POST['berat'],
				"tinggi"=>$_POST['tinggi']
			));
	}

	KunjunganTindakan::deleteByKunjungan($_GET['idk']);
	ObatKeluarDetail::deleteBySumber("kunjungan",$_GET['idk']);
	
	if(isset($_POST['tindakan'])) {
		foreach ($_POST['tindakan'] as $key=>$tindakan) {
			$m = explode(";",$tindakan);
			KunjunganTindakan::create(array(
				"id_tindakan"=>$m[0],
				"id_kunjungan"=>$_GET['idk'],
				"harga"=>$m[1],
				"harga_asli"=>$m[1],
				"jumlah"=>$_POST['jmlt'][$key]
			));
		}
	}
	if(isset($_POST['obat'])) {
		foreach ($_POST['obat'] as $key=>$obat) {
			$m = explode(";",$obat);
			ObatKeluarDetail::create(array(
				"id_obat"=>$m[0],
				"sumber"=>"kunjungan",
				"id_sumber"=>$_GET['idk'],
				"harga"=>$m[1],
				"jumlah"=>$_POST['jmlo'][$key]
			));
		}
	}

	if (Kunjungan::update($_GET['idk'],$k)) {
		redir_by_id('perawat_kunjungan');
	} else {
		redir_by_id('perawat_periksa',array(),'?idk='.$_GET['idk']);
	}
});

/**
 * Kunjungan histori
 */

Slim::get('/perawat/histori',function() {
	User::check_login('perawat');
	
	if (isset($_GET['idk'])) {
		$data = Kunjungan::getFull($_GET['idk']);
		// $pasien = Pasien::getById($data['id_pasien']);
		$obat = ObatKeluarDetail::getBySumber("kunjungan",$_GET['idk']);
		$tindakan = KunjunganTindakan::getByKunjungan($_GET['idk']);
		if ($data['id_ttv'] != null) {
			$ttv = Ttv::get($data['id_ttv']);
		} else {
			$ttv = null;
		}
		
		$data['pasien']['usia'] = intval(date('Y', time() - strtotime($data['pasien']['tgl_lahir']))) - 1970;
		$data['tanggal'] = date("d M Y",$data['tgl']);
		$data['jam'] = date("H:i",$data['tgl']);
		
		Slim::render('perawat/histori.html',array(
			'data' => $data,
			'obat' => $obat,
			'tindakan' => $tindakan,
			'ttv' => $ttv
		));
	} else {
		echo "Maaf, data tidak ditemukan.";
	}
})->name('perawat_histori');

?>